/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.declaration.UseVisitor;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.context.MatchContext;

public final class UsesMatch
extends DeclarationMatch {
    private final boolean onlyDirect;
    private final TypeReferenceMatch type;

    public UsesMatch(boolean onlyDirect, TypeReferenceMatch type) {
        this.onlyDirect = onlyDirect;
        this.type = type;
    }

    @Override
    public <M> TestResult testAnyDeclaration(Element declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        TypeVisitor<Stream<DeclaredType>, ?> visitor = UseVisitor.findUses(ctx.getModelInspector());
        Stream<DeclaredType> directUses = visitor.visit(instantiation);
        if (directUses == null) {
            return TestResult.DEFERRED;
        }
        if (this.onlyDirect) {
            return TestResult.TestableStream.testable(directUses).testAny(u -> this.type.testInstance((TypeMirror)u, ctx));
        }
        return this.testRecursively(directUses, ctx, UseVisitor.findUses(ctx.getModelInspector()));
    }

    public String toString() {
        return (this.onlyDirect ? "directly " : "") + "uses " + this.type;
    }

    private TestResult testRecursively(Stream<DeclaredType> types, MatchContext<?> ctx, TypeVisitor<Stream<DeclaredType>, ?> visitor) {
        return types == null ? TestResult.DEFERRED : TestResult.TestableStream.testable(types).testAny(t -> this.type.testInstance((TypeMirror)t, ctx).or(() -> this.testRecursively((Stream)visitor.visit((TypeMirror)t), ctx, visitor)));
    }
}

