/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.instance;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.instance.FqnMatch;
import org.revapi.classif.match.instance.TypeInstanceMatch;
import org.revapi.classif.match.instance.TypeParametersMatch;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.Globbed;

public final class SingleTypeReferenceMatch
extends TypeInstanceMatch
implements Globbed {
    private final FqnMatch fullyQualifiedName;
    private final TypeParametersMatch typeParameters;
    private final String variable;
    private final boolean negation;
    private final int arrayDimension;
    private static final ElementVisitor<List<TypeElement>, Void> TYPE_VARIABLE_TO_TYPE = new SimpleElementVisitor8<List<TypeElement>, Void>(Collections.emptyList()){

        @Override
        public List<TypeElement> visitType(TypeElement e, Void __) {
            return Collections.singletonList(e);
        }

        @Override
        public List<TypeElement> visitTypeParameter(TypeParameterElement e, Void __) {
            return e.getBounds().stream().flatMap(b -> ((List)TO_TYPE.visit((TypeMirror)b, null)).stream()).collect(Collectors.toList());
        }
    };
    private static final TypeVisitor<List<TypeElement>, Void> TO_TYPE = new SimpleTypeVisitor8<List<TypeElement>, Void>(Collections.emptyList()){

        @Override
        public List<TypeElement> visitDeclared(DeclaredType t, Void __) {
            return Collections.singletonList((TypeElement)t.asElement());
        }

        @Override
        public List<TypeElement> visitError(ErrorType t, Void __) {
            return this.visitDeclared((DeclaredType)t, null);
        }

        @Override
        public List<TypeElement> visitTypeVariable(TypeVariable t, Void __) {
            return (List)TYPE_VARIABLE_TO_TYPE.visit(t.asElement());
        }
    };

    public SingleTypeReferenceMatch(FqnMatch fullyQualifiedName, TypeParametersMatch typeParameters, String variable, boolean negation, int arrayDimension) {
        this.fullyQualifiedName = fullyQualifiedName;
        this.typeParameters = typeParameters;
        this.variable = variable;
        this.negation = negation;
        this.arrayDimension = arrayDimension;
    }

    @Override
    public boolean isMatchAny() {
        return this.fullyQualifiedName != null && this.fullyQualifiedName.isMatchAny() && this.arrayDimension == 0 && !this.negation && this.typeParameters == null;
    }

    @Override
    public boolean isMatchAll() {
        return this.fullyQualifiedName != null && this.fullyQualifiedName.isMatchAll() && this.arrayDimension == 0 && !this.negation && this.typeParameters == null;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public <M> TestResult testAnyInstance(final TypeMirror instance, final MatchContext<M> ctx) {
        return instance.accept(new SimpleTypeVisitor8<TestResult, Void>(TestResult.NOT_PASSED){

            @Override
            public TestResult visitPrimitive(PrimitiveType t, Void __) {
                TestResult ret = SingleTypeReferenceMatch.this.fullyQualifiedName == null ? TestResult.NOT_PASSED : SingleTypeReferenceMatch.this.fullyQualifiedName.testInstance(instance, ctx);
                return SingleTypeReferenceMatch.this.negation ? ret.negate() : ret;
            }

            @Override
            public TestResult visitArray(ArrayType t, Void __) {
                int dim = SingleTypeReferenceMatch.this.arrayDimension;
                TypeMirror m = t;
                while (m instanceof ArrayType) {
                    --dim;
                    m = m.getComponentType();
                }
                return dim == 0 ? (TestResult)((Object)this.visit(m)) : TestResult.NOT_PASSED;
            }

            @Override
            public TestResult visitDeclared(DeclaredType t, Void __) {
                return SingleTypeReferenceMatch.this.doTest(t, ctx);
            }

            @Override
            public TestResult visitError(ErrorType t, Void __) {
                return this.visitDeclared((DeclaredType)t, null);
            }

            @Override
            public TestResult visitTypeVariable(TypeVariable t, Void __) {
                return (TestResult)((Object)this.visit(t.getUpperBound()));
            }

            @Override
            public TestResult visitWildcard(WildcardType t, Void __) {
                if (t.getExtendsBound() != null) {
                    return (TestResult)((Object)this.visit(t.getExtendsBound()));
                }
                if (t.getSuperBound() != null) {
                    return (TestResult)((Object)this.visit(t.getSuperBound()));
                }
                TypeElement javaLangObject = ctx.getModelInspector().getJavaLangObjectElement();
                return SingleTypeReferenceMatch.this.doTest(javaLangObject.asType(), ctx);
            }

            @Override
            public TestResult visitIntersection(IntersectionType t, Void aVoid) {
                return TestResult.TestableStream.testable(t.getBounds()).testAny(this::visit);
            }

            @Override
            public TestResult visitNoType(NoType t, Void __) {
                TestResult ret = SingleTypeReferenceMatch.this.fullyQualifiedName != null ? SingleTypeReferenceMatch.this.fullyQualifiedName.testInstance(t, ctx) : TestResult.NOT_PASSED;
                return SingleTypeReferenceMatch.this.negation ? ret.negate() : ret;
            }
        }, null);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.negation ? "!" : "");
        if (this.fullyQualifiedName != null) {
            ret.append(this.fullyQualifiedName.toString());
        } else {
            ret.append("%").append(this.variable);
        }
        if (this.typeParameters != null) {
            ret.append("<").append(this.typeParameters.toString()).append(">");
        }
        for (int i = 0; i < this.arrayDimension; ++i) {
            ret.append("[]");
        }
        return ret.toString();
    }

    private <M> TestResult doTest(TypeMirror instance, MatchContext<M> ctx) {
        TestResult ret;
        if (this.fullyQualifiedName != null) {
            ret = this.fullyQualifiedName.testInstance(instance, ctx);
            if (this.typeParameters != null) {
                ret = this.typeParameters.testInstance(instance, ctx);
            }
        } else {
            StatementMatch match = ctx.getVariableMatcher(this.variable);
            ret = match != null ? TestResult.TestableStream.testable((Collection)TO_TYPE.visit(instance)).testAny(e -> match.test(ctx.getModelInspector().fromElement((Element)e), ctx)) : TestResult.NOT_PASSED;
        }
        return this.negation ? ret.negate() : ret;
    }
}

