/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class NonPublicClassPartOfAPI
extends CheckBase {
    private boolean reportUnchanged;

    @Override
    public void initialize(@Nonnull AnalysisContext analysisContext) {
        super.initialize(analysisContext);
        JsonNode reportUnchanged = analysisContext.getConfigurationNode().path("reportUnchanged");
        this.reportUnchanged = reportUnchanged.asBoolean(true);
    }

    @Override
    @Nullable
    public String getExtensionId() {
        return "nonPublicPartOfAPI";
    }

    @Override
    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/nonPublicPartOfAPI-config-schema.json"), Charset.forName("UTF-8"));
    }

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    @Override
    public boolean isDescendingOnNonExisting() {
        return true;
    }

    @Override
    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (newType == null) {
            return;
        }
        if ((this.reportUnchanged || oldType == null) && newType.isInAPI() && !this.isAccessible(newType) && !this.isMissing(newType.getDeclaringElement())) {
            this.pushActive(oldType, newType, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        return Collections.singletonList(this.createDifferenceWithExplicitParams(Code.CLASS_NON_PUBLIC_PART_OF_API, Code.attachmentsFor(types.oldElement, types.newElement, new String[0]), Util.toHumanReadableString(((JavaTypeElement)types.newElement).getModelRepresentation())));
    }
}

