/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class NonPublicClassPartOfAPI
extends CheckBase {
    private boolean reportUnchanged;

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        super.initialize(analysisContext);
        JsonNode reportUnchanged = analysisContext.getConfigurationNode().path("reportUnchanged");
        this.reportUnchanged = reportUnchanged.asBoolean(true);
    }

    @Nullable
    public String getExtensionId() {
        return "nonPublicPartOfAPI";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/nonPublicPartOfAPI-config-schema.json"), Charset.forName("UTF-8"));
    }

    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    public boolean isDescendingOnNonExisting() {
        return true;
    }

    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (newType == null) {
            return;
        }
        if ((this.reportUnchanged || oldType == null) && newType.isInAPI() && !this.isAccessible((JavaModelElement)newType) && !this.isMissing(newType.getDeclaringElement())) {
            this.pushActive((JavaElement)oldType, (JavaElement)newType, new Object[0]);
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        return Collections.singletonList(this.createDifferenceWithExplicitParams(Code.CLASS_NON_PUBLIC_PART_OF_API, Code.attachmentsFor((JavaElement)types.oldElement, (JavaElement)types.newElement, (String[])new String[0]), new String[]{Util.toHumanReadableString((AnnotatedConstruct)((JavaTypeElement)types.newElement).getModelRepresentation())}));
    }
}

