/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.FilterFinishResult;
import org.revapi.FilterMatch;
import org.revapi.FilterStartResult;
import org.revapi.TreeFilter;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.compilation.ClassPathUseSite;
import org.revapi.java.compilation.InheritedUseSite;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.compilation.UseSitePath;
import org.revapi.java.model.AbstractJavaElement;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.InitializationOptimizations;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MissingClassElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.IgnoreCompletionFailures;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClasspathScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathScanner.class);
    private static final List<Modifier> ACCESSIBLE_MODIFIERS = Arrays.asList(Modifier.PUBLIC, Modifier.PROTECTED);
    private static final String SYSTEM_CLASSPATH_NAME = "<system classpath>";
    private static final JavaFileManager.Location[] POSSIBLE_SYSTEM_CLASS_LOCATIONS = new JavaFileManager.Location[]{StandardLocation.CLASS_PATH, StandardLocation.PLATFORM_CLASS_PATH};
    private final StandardJavaFileManager fileManager;
    private final ProbingEnvironment environment;
    private final Map<Archive, File> classPath;
    private final Map<Archive, File> additionalClassPath;
    private final AnalysisConfiguration.MissingClassReporting missingClassReporting;
    private final boolean ignoreMissingAnnotations;
    private final TreeFilter<JavaElement> filter;
    private final javax.lang.model.element.TypeElement objectType;

    ClasspathScanner(StandardJavaFileManager fileManager, ProbingEnvironment environment, Map<Archive, File> classPath, Map<Archive, File> additionalClassPath, AnalysisConfiguration.MissingClassReporting missingClassReporting, boolean ignoreMissingAnnotations, TreeFilter<JavaElement> filter) {
        this.fileManager = fileManager;
        this.environment = environment;
        this.classPath = classPath;
        this.additionalClassPath = additionalClassPath;
        this.missingClassReporting = missingClassReporting == null ? AnalysisConfiguration.MissingClassReporting.ERROR : missingClassReporting;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.filter = filter;
        this.objectType = environment.getElementUtils().getTypeElement("java.lang.Object");
    }

    void initTree() throws IOException {
        List classPathLocations = this.classPath.keySet().stream().map(x$0 -> new ArchiveLocation((Archive)x$0)).collect(Collectors.toList());
        Scanner scanner = new Scanner();
        for (ArchiveLocation loc : classPathLocations) {
            scanner.scan(loc, this.classPath.get(loc.getArchive()), true);
        }
        SyntheticLocation allLoc = new SyntheticLocation();
        this.fileManager.setLocation(allLoc, this.classPath.values());
        Function<String, JavaFileObject> searchHard = className -> Stream.concat(Stream.of(allLoc), Stream.of(POSSIBLE_SYSTEM_CLASS_LOCATIONS)).map(l -> {
            try {
                return this.fileManager.getJavaFileForInput((JavaFileManager.Location)l, (String)className, JavaFileObject.Kind.CLASS);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
        Set<javax.lang.model.element.TypeElement> lastUnknowns = Collections.emptySet();
        HashMap<String, ArchiveLocation> cachedArchives = new HashMap<String, ArchiveLocation>(this.additionalClassPath.size());
        while (!scanner.requiredTypes.isEmpty() && !lastUnknowns.equals(scanner.requiredTypes.keySet())) {
            lastUnknowns = new HashSet<javax.lang.model.element.TypeElement>(scanner.requiredTypes.keySet());
            for (javax.lang.model.element.TypeElement t : lastUnknowns) {
                String path;
                String name = this.environment.getElementUtils().getBinaryName(t).toString();
                JavaFileObject jfo = searchHard.apply(name);
                if (jfo == null) continue;
                URI uri = jfo.toUri();
                if ("jar".equals(uri.getScheme())) {
                    path = uri.getSchemeSpecificPart();
                    int colonIdx = path.indexOf(58);
                    if (colonIdx >= 0) {
                        path = path.substring(colonIdx + 1);
                    }
                    path = path.substring(0, path.lastIndexOf(33));
                    int lastSlashIdx = -1;
                    for (int i = 0; i < path.length() - 1; ++i) {
                        if (path.charAt(i) != '/' || path.charAt(i + 1) == '/') continue;
                        lastSlashIdx = i;
                        break;
                    }
                    if (lastSlashIdx > 0) {
                        path = path.substring(lastSlashIdx);
                    }
                } else {
                    path = uri.getPath();
                }
                ArchiveLocation loc = (ArchiveLocation)cachedArchives.get(path);
                if (loc == null) {
                    Archive ar = null;
                    for (Map.Entry<Archive, File> e : this.additionalClassPath.entrySet()) {
                        if (!e.getValue().getAbsolutePath().equals(path)) continue;
                        ar = e.getKey();
                        break;
                    }
                    if (ar != null) {
                        loc = new ArchiveLocation(ar);
                        cachedArchives.put(path, loc);
                    }
                }
                if (loc == null) continue;
                scanner.scanClass(loc, t, false);
            }
        }
        lastUnknowns = Collections.emptySet();
        while (!scanner.requiredTypes.isEmpty() && !lastUnknowns.equals(scanner.requiredTypes.keySet())) {
            lastUnknowns = new HashSet<javax.lang.model.element.TypeElement>(scanner.requiredTypes.keySet());
            ArchiveLocation systemClassPath = new ArchiveLocation(new Archive(){

                @Nonnull
                public String getName() {
                    return ClasspathScanner.SYSTEM_CLASSPATH_NAME;
                }

                @Nonnull
                public InputStream openStream() throws IOException {
                    throw new UnsupportedOperationException();
                }
            });
            for (javax.lang.model.element.TypeElement t : lastUnknowns) {
                scanner.scanClass(systemClassPath, t, false);
            }
        }
        scanner.initEnvironment();
    }

    private static String getOverrideMapKey(MethodElement method) {
        return InitializationOptimizations.getMethodComparisonKey(method);
    }

    private boolean isGeneric(javax.lang.model.element.Element element) {
        return element.accept(new SimpleElementVisitor8<Boolean, Void>(Boolean.valueOf(false)){
            TypeVisitor<Boolean, Void> isGeneric;
            {
                this.isGeneric = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

                    @Override
                    public Boolean visitIntersection(IntersectionType t, Void __) {
                        return t.getBounds().stream().anyMatch(this::visit);
                    }

                    @Override
                    public Boolean visitDeclared(DeclaredType t, Void __) {
                        return t.getTypeArguments().stream().anyMatch(this::visit);
                    }

                    @Override
                    public Boolean visitTypeVariable(TypeVariable t, Void __) {
                        return true;
                    }

                    @Override
                    public Boolean visitWildcard(WildcardType t, Void __) {
                        if (t.getExtendsBound() != null) {
                            return (Boolean)this.visit(t.getExtendsBound());
                        }
                        if (t.getSuperBound() != null) {
                            return (Boolean)this.visit(t.getSuperBound());
                        }
                        return false;
                    }
                };
            }

            @Override
            public Boolean visitVariable(VariableElement e, Void aVoid) {
                return e.asType().accept(this.isGeneric, null);
            }

            @Override
            public Boolean visitType(javax.lang.model.element.TypeElement e, Void aVoid) {
                return !e.getTypeParameters().isEmpty();
            }

            @Override
            public Boolean visitExecutable(ExecutableElement e, Void aVoid) {
                return !e.getTypeParameters().isEmpty() || this.isGeneric.visit(e.getReturnType()) != false || e.getParameters().stream().anyMatch(this::visit);
            }
        }, null);
    }

    private static boolean movesToApi(UseSite.Type useType) {
        return useType.isMovingToApi();
    }

    static boolean shouldBeIgnored(javax.lang.model.element.Element element) {
        return Collections.disjoint(element.getModifiers(), ACCESSIBLE_MODIFIERS);
    }

    @FunctionalInterface
    private static interface UseSiteConstructor {
        public ClassPathUseSite create(UseSite.Type var1, javax.lang.model.element.Element var2, int var3);
    }

    private static final class TypeRecord {
        Set<ClassPathUseSite> useSites = new HashSet<ClassPathUseSite>(2);
        javax.lang.model.element.TypeElement javacElement;
        TypeElement modelElement;
        Map<UseSite.Type, Map<TypeRecord, Set<UseSitePath>>> usedTypes = new EnumMap<UseSite.Type, Map<TypeRecord, Set<UseSitePath>>>(UseSite.Type.class);
        Set<javax.lang.model.element.Element> accessibleDeclaredNonClassMembers = new HashSet<javax.lang.model.element.Element>(4);
        Set<javax.lang.model.element.Element> inaccessibleDeclaredNonClassMembers = new HashSet<javax.lang.model.element.Element>(4);
        Set<JavaElementBase<?, ?>> inheritableElements;
        Set<TypeRecord> superTypes = new LinkedHashSet<TypeRecord>(2);
        FilterStartResult inclusionState = FilterStartResult.undecidedAndDescend();
        TypeRecord parent;
        boolean inApi;
        boolean inApiThroughUse;
        boolean primaryApi;
        int nestingDepth;
        boolean errored;
        boolean inTree;

        private TypeRecord() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TypeRecord[");
            sb.append("inApi=").append(this.inApi);
            sb.append(", modelElement=").append((Object)this.modelElement);
            sb.append(']');
            return sb.toString();
        }
    }

    private static final class SyntheticLocation
    implements JavaFileManager.Location {
        private final String name = "randomName" + new Random().nextInt();

        private SyntheticLocation() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    }

    private static final class ArchiveLocation
    implements JavaFileManager.Location {
        private final Archive archive;

        private ArchiveLocation(Archive archive) {
            this.archive = archive;
        }

        Archive getArchive() {
            return this.archive;
        }

        @Override
        public String getName() {
            return "archiveLocation_" + this.archive.getName();
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    }

    private final class Scanner {
        final Set<javax.lang.model.element.TypeElement> processed = new HashSet<javax.lang.model.element.TypeElement>();
        final Map<javax.lang.model.element.TypeElement, Boolean> requiredTypes = new IdentityHashMap<javax.lang.model.element.TypeElement, Boolean>();
        final Map<javax.lang.model.element.TypeElement, TypeRecord> types = new IdentityHashMap<javax.lang.model.element.TypeElement, TypeRecord>();
        final TypeVisitor<javax.lang.model.element.TypeElement, Void> getTypeElement = new SimpleTypeVisitor8<javax.lang.model.element.TypeElement, Void>(){

            @Override
            protected javax.lang.model.element.TypeElement defaultAction(TypeMirror e, Void ignored) {
                throw new IllegalStateException("Could not determine the element of a type: " + e);
            }

            @Override
            public javax.lang.model.element.TypeElement visitDeclared(DeclaredType t, Void ignored) {
                return (javax.lang.model.element.TypeElement)t.asElement();
            }

            @Override
            public javax.lang.model.element.TypeElement visitTypeVariable(TypeVariable t, Void ignored) {
                return t.getUpperBound().accept(this, null);
            }

            @Override
            public javax.lang.model.element.TypeElement visitArray(ArrayType t, Void ignored) {
                return t.getComponentType().accept(this, null);
            }

            @Override
            public javax.lang.model.element.TypeElement visitPrimitive(PrimitiveType t, Void ignored) {
                return null;
            }

            @Override
            public javax.lang.model.element.TypeElement visitIntersection(IntersectionType t, Void aVoid) {
                return t.getBounds().get(0).accept(this, null);
            }

            @Override
            public javax.lang.model.element.TypeElement visitWildcard(WildcardType t, Void aVoid) {
                if (t.getExtendsBound() != null) {
                    return t.getExtendsBound().accept(this, null);
                }
                if (t.getSuperBound() != null) {
                    return t.getSuperBound().accept(this, null);
                }
                return ClasspathScanner.this.environment.getElementUtils().getTypeElement("java.lang.Object");
            }

            @Override
            public javax.lang.model.element.TypeElement visitNoType(NoType t, Void aVoid) {
                return null;
            }

            @Override
            public javax.lang.model.element.TypeElement visitError(ErrorType t, Void aVoid) {
                return (javax.lang.model.element.TypeElement)t.asElement();
            }
        };

        private Scanner() {
        }

        void scan(ArchiveLocation location, File path, boolean primaryApi) throws IOException {
            ClasspathScanner.this.fileManager.setLocation(location, Collections.singleton(path));
            Iterable<JavaFileObject> jfos = ClasspathScanner.this.fileManager.list(location, "", EnumSet.of(JavaFileObject.Kind.CLASS), true);
            for (JavaFileObject jfo : jfos) {
                javax.lang.model.element.TypeElement type = Util.findTypeByBinaryName((Elements)ClasspathScanner.this.environment.getElementUtils(), (String)ClasspathScanner.this.fileManager.inferBinaryName(location, jfo));
                if (type == null) continue;
                this.scanClass(location, type, primaryApi);
            }
        }

        void scanClass(ArchiveLocation loc, javax.lang.model.element.TypeElement type, boolean primaryApi) {
            try {
                if (this.processed.contains(type)) {
                    return;
                }
                this.processed.add(type);
                Boolean wasAnno = this.requiredTypes.remove(type);
                javax.lang.model.element.TypeElement superType = this.getTypeElement.visit((TypeMirror)IgnoreCompletionFailures.in(type::getSuperclass));
                TypeMirror typeType = type.asType();
                if (typeType.getKind() == TypeKind.ERROR) {
                    this.requiredTypes.put(type, wasAnno == null ? false : wasAnno);
                    return;
                }
                TypeElement t = new TypeElement(ClasspathScanner.this.environment, loc.getArchive(), type, (DeclaredType)type.asType());
                TypeRecord tr = this.getTypeRecord(type);
                tr.inclusionState = ClasspathScanner.this.filter.start((Element)t);
                tr.modelElement = t;
                tr.inApi = tr.inclusionState.getMatch().toBoolean(true) && primaryApi && !ClasspathScanner.shouldBeIgnored(type) && !(type.getEnclosingElement() instanceof javax.lang.model.element.TypeElement);
                tr.primaryApi = primaryApi;
                if (type.getEnclosingElement() instanceof javax.lang.model.element.TypeElement) {
                    tr.parent = this.getTypeRecord((javax.lang.model.element.TypeElement)type.getEnclosingElement());
                }
                if (!type.equals(ClasspathScanner.this.objectType)) {
                    tr.superTypes.add(this.getTypeRecord(ClasspathScanner.this.objectType));
                    if (!this.processed.contains(ClasspathScanner.this.objectType)) {
                        this.requiredTypes.put(ClasspathScanner.this.objectType, false);
                    }
                }
                if (!tr.inclusionState.isDescend()) {
                    return;
                }
                if (superType != null) {
                    this.addUse(tr, type, superType, UseSite.Type.IS_INHERITED);
                    tr.superTypes.add(this.getTypeRecord(superType));
                    if (!this.processed.contains(superType)) {
                        this.requiredTypes.put(superType, false);
                    }
                }
                ((List)IgnoreCompletionFailures.in(type::getInterfaces)).stream().map(this.getTypeElement::visit).forEach(e -> {
                    if (!this.processed.contains(e)) {
                        this.requiredTypes.put((javax.lang.model.element.TypeElement)e, false);
                    }
                    this.addUse(tr, type, (javax.lang.model.element.TypeElement)e, UseSite.Type.IS_IMPLEMENTED);
                    tr.superTypes.add(this.getTypeRecord((javax.lang.model.element.TypeElement)e));
                });
                this.addTypeParamUses(tr, type, type.asType());
                if (tr.inclusionState.isDescend()) {
                    for (javax.lang.model.element.Element e2 : (List)IgnoreCompletionFailures.in(type::getEnclosedElements)) {
                        switch (e2.getKind()) {
                            case ANNOTATION_TYPE: 
                            case CLASS: 
                            case ENUM: 
                            case INTERFACE: {
                                this.addUse(tr, type, (javax.lang.model.element.TypeElement)e2, UseSite.Type.CONTAINS);
                                this.scanClass(loc, (javax.lang.model.element.TypeElement)e2, tr.inApi);
                                break;
                            }
                            case CONSTRUCTOR: 
                            case METHOD: {
                                this.scanMethod(tr, (ExecutableElement)e2);
                                break;
                            }
                            case ENUM_CONSTANT: 
                            case FIELD: {
                                this.scanField(tr, (VariableElement)e2);
                            }
                        }
                    }
                }
                type.getAnnotationMirrors().forEach(a -> this.scanAnnotation(tr, type, -1, (AnnotationMirror)a));
                this.finishFiltering(tr, t);
            }
            catch (Exception e3) {
                LOG.error("Failed to scan class " + type.getQualifiedName().toString() + ". Analysis results may be skewed.", (Throwable)e3);
                TypeRecord tr = this.getTypeRecord(type);
                tr.errored = true;
                if (tr.modelElement != null && tr.inclusionState != null) {
                    this.finishFiltering(tr, tr.modelElement);
                }
                tr.inclusionState = FilterStartResult.doesntMatch();
            }
        }

        void placeInTree(TypeRecord typeRecord) {
            if (typeRecord.parent == null) {
                ClasspathScanner.this.environment.getTree().getRootsUnsafe().add(typeRecord.modelElement);
            } else if (typeRecord.parent.inTree) {
                typeRecord.parent.modelElement.getChildren().add(typeRecord.modelElement);
            } else {
                TypeRecord parent = typeRecord.parent;
                while (!(parent == null || parent.inTree && parent.modelElement != null)) {
                    parent = parent.parent;
                }
                if (parent == null) {
                    ClasspathScanner.this.environment.getTree().getRootsUnsafe().add(typeRecord.modelElement);
                } else {
                    parent.modelElement.getChildren().add(typeRecord.modelElement);
                }
            }
        }

        void scanField(TypeRecord owningType, VariableElement field) {
            if (ClasspathScanner.shouldBeIgnored(field)) {
                owningType.inaccessibleDeclaredNonClassMembers.add(field);
                return;
            }
            owningType.accessibleDeclaredNonClassMembers.add(field);
            javax.lang.model.element.TypeElement fieldType = field.asType().accept(this.getTypeElement, null);
            if (fieldType != null) {
                this.addUse(owningType, field, fieldType, UseSite.Type.HAS_TYPE);
                this.addType(fieldType, false);
                this.addTypeParamUses(owningType, field, field.asType());
            }
            field.getAnnotationMirrors().forEach(a -> this.scanAnnotation(owningType, field, -1, (AnnotationMirror)a));
        }

        void scanMethod(TypeRecord owningType, ExecutableElement method) {
            if (ClasspathScanner.shouldBeIgnored(method)) {
                owningType.inaccessibleDeclaredNonClassMembers.add(method);
                return;
            }
            owningType.accessibleDeclaredNonClassMembers.add(method);
            javax.lang.model.element.TypeElement returnType = method.getReturnType().accept(this.getTypeElement, null);
            if (returnType != null) {
                this.addUse(owningType, method, returnType, UseSite.Type.RETURN_TYPE);
                this.addType(returnType, false);
                this.addTypeParamUses(owningType, method, method.getReturnType());
            }
            int idx = 0;
            for (VariableElement variableElement : method.getParameters()) {
                javax.lang.model.element.TypeElement pt = variableElement.asType().accept(this.getTypeElement, null);
                if (pt != null) {
                    this.addUse(owningType, method, pt, UseSite.Type.PARAMETER_TYPE, idx);
                    this.addType(pt, false);
                    this.addTypeParamUses(owningType, method, variableElement.asType());
                }
                for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                    this.scanAnnotation(owningType, variableElement, idx, annotationMirror);
                }
            }
            method.getThrownTypes().forEach(t -> {
                javax.lang.model.element.TypeElement ex = t.accept(this.getTypeElement, null);
                if (ex != null) {
                    this.addUse(owningType, method, ex, UseSite.Type.IS_THROWN);
                    this.addType(ex, false);
                    this.addTypeParamUses(owningType, method, (TypeMirror)t);
                }
                t.getAnnotationMirrors().forEach(a -> this.scanAnnotation(owningType, method, -1, (AnnotationMirror)a));
            });
            method.getAnnotationMirrors().forEach(a -> this.scanAnnotation(owningType, method, -1, (AnnotationMirror)a));
        }

        void scanAnnotation(TypeRecord owningType, javax.lang.model.element.Element annotated, int indexInParent, AnnotationMirror annotation) {
            javax.lang.model.element.TypeElement type = annotation.getAnnotationType().accept(this.getTypeElement, null);
            if (type != null) {
                this.addUse(owningType, annotated, type, UseSite.Type.ANNOTATES, indexInParent);
                this.addType(type, true);
            }
        }

        boolean addType(javax.lang.model.element.TypeElement type, boolean isAnnotation) {
            if (this.processed.contains(type)) {
                return true;
            }
            this.requiredTypes.put(type, isAnnotation);
            return false;
        }

        void addTypeParamUses(TypeRecord userType, javax.lang.model.element.Element user, TypeMirror usedType) {
            this.addTypeParamUses(userType, user, usedType, t -> this.addUse(userType, user, (javax.lang.model.element.TypeElement)t, UseSite.Type.TYPE_PARAMETER_OR_BOUND));
        }

        void addTypeParamUses(TypeRecord userType, javax.lang.model.element.Element user, final TypeMirror usedType, final Consumer<javax.lang.model.element.TypeElement> addUseFn) {
            final HashSet visited = new HashSet(4);
            usedType.accept(new SimpleTypeVisitor8<Void, Void>(){

                @Override
                public Void visitIntersection(IntersectionType t, Void aVoid) {
                    t.getBounds().forEach(b -> b.accept(this, null));
                    return null;
                }

                @Override
                public Void visitArray(ArrayType t, Void ignored) {
                    return t.getComponentType().accept(this, null);
                }

                @Override
                public Void visitDeclared(DeclaredType t, Void ignored) {
                    String type = Util.toUniqueString((TypeMirror)t);
                    if (!visited.contains(type)) {
                        visited.add(type);
                        if (t != usedType) {
                            javax.lang.model.element.TypeElement typeEl = (javax.lang.model.element.TypeElement)t.asElement();
                            Scanner.this.addType(typeEl, false);
                            addUseFn.accept(typeEl);
                        }
                        t.getTypeArguments().forEach(a -> a.accept(this, null));
                    }
                    return null;
                }

                @Override
                public Void visitTypeVariable(TypeVariable t, Void ignored) {
                    return t.getUpperBound().accept(this, null);
                }

                @Override
                public Void visitWildcard(WildcardType t, Void ignored) {
                    TypeMirror bound = t.getExtendsBound();
                    if (bound != null) {
                        bound.accept(this, null);
                    }
                    if ((bound = t.getSuperBound()) != null) {
                        bound.accept(this, null);
                    }
                    return null;
                }
            }, null);
        }

        void addUse(TypeRecord userType, javax.lang.model.element.Element user, javax.lang.model.element.TypeElement used, UseSite.Type useType) {
            this.addUse(userType, user, used, useType, -1);
        }

        void addUse(TypeRecord userType, javax.lang.model.element.Element user, javax.lang.model.element.TypeElement used, UseSite.Type useType, int indexInParent) {
            this.addUse(userType, user, used, useType, indexInParent, ClassPathUseSite::new);
        }

        void addUse(TypeRecord userType, javax.lang.model.element.Element user, javax.lang.model.element.TypeElement used, UseSite.Type useType, int indexInParent, UseSiteConstructor ctor) {
            TypeRecord usedTr = this.getTypeRecord(used);
            Set<ClassPathUseSite> sites = usedTr.useSites;
            sites.add(ctor.create(useType, user, indexInParent));
            Map usedTypes = userType.usedTypes.computeIfAbsent(useType, k -> new HashMap(4));
            usedTypes.computeIfAbsent(usedTr, __ -> new HashSet(4)).add(new UseSitePath(userType.javacElement, user));
        }

        TypeRecord getTypeRecord(javax.lang.model.element.TypeElement type) {
            TypeRecord rec = this.types.get(type);
            if (rec == null) {
                rec = new TypeRecord();
                rec.javacElement = type;
                int depth = 0;
                for (javax.lang.model.element.Element e = type.getEnclosingElement(); e != null && e instanceof javax.lang.model.element.TypeElement; e = e.getEnclosingElement()) {
                    ++depth;
                }
                rec.nestingDepth = depth;
                this.types.put(type, rec);
            }
            return rec;
        }

        void initEnvironment() {
            List reallyMissing;
            if (ClasspathScanner.this.ignoreMissingAnnotations && !this.requiredTypes.isEmpty()) {
                this.removeAnnotatesUses();
            }
            this.moveInnerClassesOfPrimariesToApi();
            this.initChildren();
            this.determineApiStatus();
            if (ClasspathScanner.this.missingClassReporting == AnalysisConfiguration.MissingClassReporting.REPORT && !this.requiredTypes.isEmpty()) {
                this.handleMissingClasses(this.types);
            }
            Set<TypeRecord> types = this.constructTree();
            if (ClasspathScanner.this.missingClassReporting == AnalysisConfiguration.MissingClassReporting.ERROR && !(reallyMissing = types.stream().filter(tr -> tr.modelElement instanceof MissingClassElement).map(tr -> tr.modelElement.getCanonicalName()).collect(Collectors.toList())).isEmpty()) {
                throw new IllegalStateException("The following classes that contribute to the public API of " + ClasspathScanner.this.environment.getApi() + " could not be located: " + reallyMissing);
            }
            ClasspathScanner.this.environment.setTypeMap(types.stream().collect(Collectors.toMap(tr -> tr.javacElement, tr -> tr.modelElement)));
        }

        private void handleMissingClasses(Map<javax.lang.model.element.TypeElement, TypeRecord> types) {
            Elements els = ClasspathScanner.this.environment.getElementUtils();
            for (javax.lang.model.element.TypeElement t : this.requiredTypes.keySet()) {
                javax.lang.model.element.TypeElement type = els.getTypeElement(t.getQualifiedName());
                if (type != null) continue;
                TypeRecord tr = this.types.get(t);
                String bin = els.getBinaryName(t).toString();
                MissingClassElement mce = new MissingClassElement(ClasspathScanner.this.environment, bin, t.getQualifiedName().toString());
                if (tr == null) {
                    tr = new TypeRecord();
                }
                mce.setInApi(tr.inApi);
                mce.setInApiThroughUse(tr.inApiThroughUse);
                mce.setRawUseSites(tr.useSites);
                tr.javacElement = mce.getDeclaringElement();
                tr.modelElement = mce;
                types.put(tr.javacElement, tr);
            }
        }

        private Set<TypeRecord> constructTree() {
            HashSet<TypeRecord> types = new HashSet<TypeRecord>();
            HashSet ignored = new HashSet();
            Comparator byNestingDepth = (a, b) -> {
                TypeRecord ar = (TypeRecord)a.getValue();
                TypeRecord br = (TypeRecord)b.getValue();
                int ret = ar.nestingDepth - br.nestingDepth;
                if (ret == 0) {
                    ret = ((javax.lang.model.element.TypeElement)a.getKey()).getQualifiedName().toString().compareTo(((javax.lang.model.element.TypeElement)b.getKey()).getQualifiedName().toString());
                }
                return ret;
            };
            this.types.entrySet().stream().sorted(byNestingDepth).forEach(e -> {
                javax.lang.model.element.TypeElement t = (javax.lang.model.element.TypeElement)e.getKey();
                TypeRecord r = (TypeRecord)e.getValue();
                if (r.errored) {
                    return;
                }
                if (!(r.modelElement == null || r.modelElement.getArchive() != null && r.modelElement.getArchive().getName().equals(ClasspathScanner.SYSTEM_CLASSPATH_NAME))) {
                    boolean include = r.inclusionState.getMatch() != FilterMatch.DOESNT_MATCH || r.inclusionState.isDescend();
                    javax.lang.model.element.Element owner = t.getEnclosingElement();
                    if (owner != null && owner instanceof javax.lang.model.element.TypeElement) {
                        ArrayDeque<javax.lang.model.element.TypeElement> owners = new ArrayDeque<javax.lang.model.element.TypeElement>();
                        while (owner != null && owner instanceof javax.lang.model.element.TypeElement) {
                            owners.push((javax.lang.model.element.TypeElement)owner);
                            owner = owner.getEnclosingElement();
                        }
                        List<Object> siblings = ClasspathScanner.this.environment.getTree().getRootsUnsafe().stream().map(TypeElement.class::cast).map(JavaElementBase::getDeclaringElement).collect(Collectors.toList());
                        while (!(owners.isEmpty() || ignored.contains(owners.peek()) || siblings.contains(owners.peek()))) {
                            owners.pop();
                        }
                        if (!include && !owners.isEmpty()) {
                            do {
                                javax.lang.model.element.TypeElement o;
                                include = !ignored.contains(o = (javax.lang.model.element.TypeElement)owners.pop()) && siblings.contains(o);
                                siblings = ElementFilter.typesIn(o.getEnclosedElements());
                            } while (include && !owners.isEmpty());
                        }
                    }
                    if (include) {
                        this.placeInTree(r);
                        r.inTree = true;
                        r.modelElement.setRawUseSites(r.useSites);
                        r.modelElement.setRawUsedTypes(r.usedTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().filter(typeE -> ((TypeRecord)typeE.getKey()).modelElement != null).collect(Collectors.toMap(typeE -> ((TypeRecord)typeE.getKey()).modelElement, Map.Entry::getValue)))));
                        types.add(r);
                        ClasspathScanner.this.environment.setSuperTypes(r.javacElement, r.superTypes.stream().map(tr -> tr.javacElement).collect(Collectors.toList()));
                        r.modelElement.setInApi(r.inApi);
                        r.modelElement.setInApiThroughUse(r.inApiThroughUse);
                    }
                }
            });
            return types;
        }

        private void determineApiStatus() {
            Set<TypeRecord> undetermined = new HashSet<TypeRecord>(this.types.values());
            while (!undetermined.isEmpty()) {
                undetermined = undetermined.stream().filter(tr -> tr.inclusionState.getMatch() != FilterMatch.DOESNT_MATCH || tr.inclusionState.isDescend()).filter(tr -> tr.inApi).flatMap(tr -> tr.usedTypes.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<TypeRecord, Map.Entry>((TypeRecord)tr, (Map.Entry)e))).filter(e -> ClasspathScanner.movesToApi((UseSite.Type)((Map.Entry)e.getValue()).getKey())).flatMap(e -> ((Map)((Map.Entry)e.getValue()).getValue()).keySet().stream()).filter(usedTr -> !usedTr.inApi).filter(usedTr -> usedTr.inclusionState.getMatch() != FilterMatch.DOESNT_MATCH || usedTr.inclusionState.isDescend()).peek(usedTr -> {
                    if (usedTr.inclusionState.getMatch() != FilterMatch.DOESNT_MATCH || !usedTr.inclusionState.isInherited()) {
                        usedTr.inApi = true;
                        usedTr.inApiThroughUse = true;
                    }
                }).collect(Collectors.toSet());
            }
        }

        private void moveInnerClassesOfPrimariesToApi() {
            Set primaries = this.types.values().stream().filter(tr -> tr.primaryApi).filter(tr -> tr.inApi).filter(tr -> tr.nestingDepth == 0).collect(Collectors.toSet());
            while (!primaries.isEmpty()) {
                primaries = primaries.stream().flatMap(tr -> tr.usedTypes.getOrDefault(UseSite.Type.CONTAINS, Collections.emptyMap()).keySet().stream()).filter(containedTr -> containedTr.modelElement != null).filter(containedTr -> !ClasspathScanner.shouldBeIgnored(containedTr.modelElement.getDeclaringElement())).peek(containedTr -> {
                    containedTr.inApi = true;
                }).collect(Collectors.toSet());
            }
        }

        private void removeAnnotatesUses() {
            Map<javax.lang.model.element.TypeElement, Boolean> newTypes = this.requiredTypes.entrySet().stream().filter(e -> {
                boolean isAnno = (Boolean)e.getValue();
                if (isAnno) {
                    this.types.get(e.getKey()).useSites.clear();
                }
                return !isAnno;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.requiredTypes.clear();
            this.requiredTypes.putAll(newTypes);
        }

        private void initChildren() {
            ArrayList<TypeRecord> copy;
            do {
                copy = new ArrayList<TypeRecord>(this.types.values());
                copy.forEach(this::initChildren);
            } while (this.types.size() != copy.size());
        }

        private void initChildren(TypeRecord tr) {
            if (tr.modelElement == null) {
                tr.inheritableElements = Collections.emptySet();
                return;
            }
            if (tr.inheritableElements != null) {
                return;
            }
            tr.inheritableElements = new HashSet(4);
            HashSet methods = new HashSet(8);
            Consumer<JavaElementBase> addOverride = e -> {
                if (e instanceof MethodElement) {
                    MethodElement me = (MethodElement)((Object)((Object)e));
                    methods.add(ClasspathScanner.getOverrideMapKey(me));
                }
            };
            Consumer<JavaElementBase> initChildren = e -> {
                FilterStartResult fr = ClasspathScanner.this.filter.start((Element)e);
                if (fr.isDescend()) {
                    this.initNonClassElementChildren(tr, (JavaElementBase<?, ?>)((Object)((Object)e)), false);
                }
                this.finishFiltering(tr, (JavaElementBase<?, ?>)((Object)((Object)e)));
            };
            tr.accessibleDeclaredNonClassMembers.stream().map(e -> JavaElementFactory.elementFor(e, e.asType(), ClasspathScanner.this.environment, tr.modelElement.getArchive())).peek(addOverride).peek(c -> {
                tr.modelElement.getChildren().add(c);
                tr.inheritableElements.add((JavaElementBase<?, ?>)((Object)((Object)c)));
            }).forEach(initChildren);
            tr.inaccessibleDeclaredNonClassMembers.stream().map(e -> JavaElementFactory.elementFor(e, e.asType(), ClasspathScanner.this.environment, tr.modelElement.getArchive())).peek(addOverride).peek(c -> tr.modelElement.getChildren().add(c)).forEach(initChildren);
            tr.superTypes.forEach(str -> this.addInherited(tr, (TypeRecord)str, methods));
            for (AnnotationMirror annotationMirror : tr.javacElement.getAnnotationMirrors()) {
                tr.modelElement.getChildren().add(new AnnotationElement(ClasspathScanner.this.environment, tr.modelElement.getArchive(), annotationMirror));
            }
        }

        private void addInherited(TypeRecord target, TypeRecord superType, Set<String> methodOverrideMap) {
            Types types = ClasspathScanner.this.environment.getTypeUtils();
            if (superType.inheritableElements == null) {
                this.initChildren(superType);
            }
            for (JavaElementBase<?, ?> e : superType.inheritableElements) {
                FilterStartResult fr;
                JavaElementBase<?, ?> ret;
                if (e instanceof MethodElement && !this.shouldAddInheritedMethodChild((MethodElement)e, methodOverrideMap)) continue;
                if (ClasspathScanner.this.isGeneric(e.getDeclaringElement())) {
                    TypeMirror elementType = types.asMemberOf((DeclaredType)target.javacElement.asType(), (javax.lang.model.element.Element)e.getDeclaringElement());
                    ret = JavaElementFactory.elementFor(e.getDeclaringElement(), elementType, ClasspathScanner.this.environment, target.modelElement.getArchive());
                    if (!target.modelElement.getChildren().add(ret)) continue;
                    fr = ClasspathScanner.this.filter.start(ret);
                    if (fr.isDescend()) {
                        this.initNonClassElementChildren(target, ret, true);
                    }
                    this.finishFiltering(target, ret);
                } else {
                    Optional<JavaElementBase<?, ?>> copy;
                    if (target.inApi) {
                        InitializationOptimizations.initializeComparator(e);
                    }
                    if (!(copy = e.cloneUnder(target.modelElement)).isPresent()) continue;
                    ret = copy.get();
                    ret.setArchive(target.modelElement.getArchive());
                    fr = ClasspathScanner.this.filter.start(ret);
                    if (fr.isDescend()) {
                        this.copyInheritedNonClassElementChildren(target, ret, e.getChildren(), target.inApi);
                    }
                    this.finishFiltering(target, ret);
                }
                this.addUseSites(target, ret);
                ret.setInherited(true);
            }
            for (TypeRecord st : superType.superTypes) {
                this.addInherited(target, st, methodOverrideMap);
            }
        }

        private void addUseSites(TypeRecord target, JavaElementBase<?, ?> targetEl) {
            if (targetEl instanceof FieldElement) {
                this.addFieldUseSites(target, (FieldElement)targetEl);
            } else if (targetEl instanceof MethodElement) {
                this.addMethodUseSites(target, (MethodElement)targetEl);
            }
        }

        private void addFieldUseSites(TypeRecord target, FieldElement targetF) {
            Object usedType = targetF.getModelRepresentation();
            javax.lang.model.element.TypeElement usedEl = this.getTypeElement.visit((TypeMirror)usedType);
            if (usedEl == null) {
                return;
            }
            VariableElement f = (VariableElement)targetF.getDeclaringElement();
            UseSiteConstructor ctor = (useType, site, indexInParent) -> new InheritedUseSite(useType, site, target.modelElement, indexInParent);
            this.addUse(target, f, usedEl, UseSite.Type.HAS_TYPE, -1, ctor);
            this.addTypeParamUses(target, f, (TypeMirror)usedType, t -> this.addUse(target, f, (javax.lang.model.element.TypeElement)t, UseSite.Type.TYPE_PARAMETER_OR_BOUND, -1, ctor));
        }

        private void addMethodUseSites(TypeRecord target, MethodElement targetM) {
            UseSiteConstructor ctor = (useType, site, indexInParent) -> new InheritedUseSite(useType, site, target.modelElement, indexInParent);
            ExecutableType methodType = (ExecutableType)targetM.getModelRepresentation();
            ExecutableElement method = (ExecutableElement)targetM.getDeclaringElement();
            TypeMirror retType = methodType.getReturnType();
            javax.lang.model.element.TypeElement retEl = this.getTypeElement.visit(retType);
            if (retEl != null) {
                this.addUse(target, method, retEl, UseSite.Type.RETURN_TYPE, -1, ctor);
                this.addTypeParamUses(target, method, retType, v -> this.addUse(target, method, (javax.lang.model.element.TypeElement)v, UseSite.Type.TYPE_PARAMETER_OR_BOUND, -1, ctor));
            }
            int i = 0;
            for (TypeMirror typeMirror : methodType.getParameterTypes()) {
                javax.lang.model.element.TypeElement pEl = this.getTypeElement.visit(typeMirror);
                if (pEl == null) continue;
                this.addUse(target, (javax.lang.model.element.Element)targetM.getDeclaringElement(), pEl, UseSite.Type.PARAMETER_TYPE, i++, ctor);
                this.addTypeParamUses(target, method, typeMirror, v -> this.addUse(target, method, (javax.lang.model.element.TypeElement)v, UseSite.Type.TYPE_PARAMETER_OR_BOUND, -1, ctor));
            }
            for (TypeMirror typeMirror : methodType.getThrownTypes()) {
                this.addUse(target, (javax.lang.model.element.Element)targetM.getDeclaringElement(), this.getTypeElement.visit(typeMirror), UseSite.Type.IS_THROWN, i++, ctor);
                this.addTypeParamUses(target, method, typeMirror, v -> this.addUse(target, method, (javax.lang.model.element.TypeElement)v, UseSite.Type.TYPE_PARAMETER_OR_BOUND, -1, ctor));
            }
        }

        private void finishFiltering(TypeRecord elementOwner, JavaElementBase<?, ?> el) {
            FilterFinishResult finish = ClasspathScanner.this.filter.finish(el);
            if (finish.getMatch() == FilterMatch.DOESNT_MATCH && el.getParent() != null) {
                el.getParent().getChildren().remove(el);
            }
            if (el instanceof TypeElement) {
                TypeRecord tr = this.getTypeRecord((javax.lang.model.element.TypeElement)el.getDeclaringElement());
                tr.inclusionState = tr.inclusionState.withMatch(finish.getMatch());
                if (tr == elementOwner) {
                    return;
                }
            }
            if (!finish.isInherited() && finish.getMatch().toBoolean(false)) {
                while (elementOwner != null) {
                    elementOwner.inclusionState = elementOwner.inclusionState.or(FilterStartResult.from((FilterFinishResult)finish, (boolean)elementOwner.inclusionState.isDescend()));
                    elementOwner = elementOwner.parent;
                }
            }
        }

        private boolean shouldAddInheritedMethodChild(MethodElement methodElement, Set<String> overrideMap) {
            if (((ExecutableElement)methodElement.getDeclaringElement()).getKind() == ElementKind.CONSTRUCTOR) {
                return false;
            }
            String overrideKey = ClasspathScanner.getOverrideMapKey(methodElement);
            boolean alreadyIncludedMethod = overrideMap.contains(overrideKey);
            if (alreadyIncludedMethod) {
                return false;
            }
            overrideMap.add(overrideKey);
            return true;
        }

        private void initNonClassElementChildren(TypeRecord parentOwner, JavaElementBase<?, ?> parent, boolean inherited) {
            Types types = ClasspathScanner.this.environment.getTypeUtils();
            List<? extends javax.lang.model.element.Element> children = parent.getDeclaringElement().accept(new SimpleElementVisitor8<List<? extends javax.lang.model.element.Element>, Void>(){

                @Override
                protected List<? extends javax.lang.model.element.Element> defaultAction(javax.lang.model.element.Element e, Void aVoid) {
                    return Collections.emptyList();
                }

                @Override
                public List<? extends javax.lang.model.element.Element> visitType(javax.lang.model.element.TypeElement e, Void aVoid) {
                    return e.getEnclosedElements();
                }

                @Override
                public List<? extends javax.lang.model.element.Element> visitExecutable(ExecutableElement e, Void aVoid) {
                    return e.getParameters();
                }
            }, null);
            for (javax.lang.model.element.Element element : children) {
                if (element.getKind().isClass() || element.getKind().isInterface()) continue;
                TypeMirror representation = (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) && ClasspathScanner.this.isGeneric(element) ? types.asMemberOf((DeclaredType)parentOwner.modelElement.getModelRepresentation(), element) : element.asType();
                JavaElementBase<?, ?> childEl = JavaElementFactory.elementFor(element, representation, ClasspathScanner.this.environment, parent.getArchive());
                childEl.setInherited(inherited);
                parent.getChildren().add(childEl);
                FilterStartResult fr = ClasspathScanner.this.filter.start(childEl);
                if (fr.isDescend()) {
                    this.initNonClassElementChildren(parentOwner, childEl, inherited);
                }
                this.finishFiltering(parentOwner, childEl);
            }
            for (AnnotationMirror annotationMirror : parent.getDeclaringElement().getAnnotationMirrors()) {
                parent.getChildren().add(new AnnotationElement(ClasspathScanner.this.environment, parent.getArchive(), annotationMirror));
            }
        }

        private void copyInheritedNonClassElementChildren(TypeRecord parentOwner, JavaElementBase<?, ?> parent, Iterable<? extends JavaElement> sourceChildren, boolean forceComparatorInitialization) {
            for (JavaElement javaElement : sourceChildren) {
                if (javaElement instanceof javax.lang.model.element.TypeElement) continue;
                if (forceComparatorInitialization) {
                    InitializationOptimizations.initializeComparator(javaElement);
                }
                JavaElement cc = InitializationOptimizations.clone(javaElement);
                parent.getChildren().add(cc);
                if (!(cc instanceof AbstractJavaElement)) continue;
                ((AbstractJavaElement)cc).setArchive(parent.getArchive());
                if (!(cc instanceof JavaElementBase)) continue;
                JavaElementBase mcc = (JavaElementBase)cc;
                mcc.setInherited(true);
                this.copyInheritedNonClassElementChildren(parentOwner, mcc, javaElement.getChildren(), forceComparatorInitialization);
            }
        }
    }
}

