/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.AnnotationMatch;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.progress.context.MatchContext;

public final class AnnotationsMatch
extends DeclarationMatch {
    private final List<AnnotationMatch> annotations;

    public AnnotationsMatch(List<AnnotationMatch> annotations) {
        this.annotations = annotations;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    @Override
    protected <M> TestResult defaultTest(Element e, TypeMirror inst, MatchContext<M> matchContext) {
        return TestResult.TestableStream.testable(this.annotations).testAll(m -> {
            List<? extends AnnotationMirror> annos = e.getAnnotationMirrors();
            if (annos.isEmpty()) {
                return TestResult.fromBoolean(m.isNegation());
            }
            return TestResult.TestableStream.testable(annos).testAny(a -> m.test((AnnotationMirror)a, matchContext));
        });
    }

    public String toString() {
        return this.annotations.stream().map(Object::toString).collect(Collectors.joining(" "));
    }
}

