/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.context.MatchContext;

public final class ExtendsMatch
extends DeclarationMatch {
    private static final TypeVisitor<TypeMirror, Void> GET_SUPER_CLASS = new SimpleTypeVisitor8<TypeMirror, Void>(){

        @Override
        public TypeMirror visitDeclared(DeclaredType t, Void __) {
            return ((TypeElement)t.asElement()).getSuperclass();
        }

        @Override
        public TypeMirror visitError(ErrorType t, Void __) {
            return this.visitDeclared((DeclaredType)t, null);
        }
    };
    private final boolean onlyDirect;
    private final TypeReferenceMatch superTypeMatch;

    public ExtendsMatch(boolean onlyDirect, TypeReferenceMatch superTypeMatch) {
        this.onlyDirect = onlyDirect;
        this.superTypeMatch = superTypeMatch;
    }

    @Override
    protected <M> TestResult testType(TypeElement declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        if (this.onlyDirect) {
            return this.superTypeMatch.testInstance(declaration.getSuperclass(), ctx);
        }
        return this.someSuperTypeMatches(declaration.getSuperclass(), ctx);
    }

    public String toString() {
        return (this.onlyDirect ? "directly " : "") + "extends " + this.superTypeMatch.toString();
    }

    private <M> TestResult someSuperTypeMatches(TypeMirror superType, MatchContext<M> ctx) {
        TestResult ret = TestResult.NOT_PASSED;
        while (superType != null && superType.getKind() != TypeKind.NONE) {
            if ((ret = ret.or(this.superTypeMatch.testInstance(superType, ctx))).toBoolean(false)) {
                return ret;
            }
            superType = GET_SUPER_CLASS.visit(superType);
        }
        return ret;
    }
}

