/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.revapi.classif.ModelInspector;

final class UseVisitor {
    private UseVisitor() {
    }

    static <M> TypeVisitor<Stream<DeclaredType>, ?> findUses(final ModelInspector<M> insp) {
        return new SimpleTypeVisitor8<Stream<DeclaredType>, Void>(Stream.empty()){
            private HashSet<TypeMirror> visited;
            private int depth;
            {
                super(x0);
                this.visited = new HashSet();
            }

            @Override
            public Stream<DeclaredType> visitIntersection(IntersectionType t, Void __) {
                return this.nest(() -> t.getBounds().stream().flatMap(b -> this.nest(() -> (Stream)this.visit((TypeMirror)b, null))));
            }

            @Override
            public Stream<DeclaredType> visitArray(ArrayType t, Void __) {
                return this.nest(() -> (Stream)this.visit(t.getComponentType(), null));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Stream<DeclaredType> visitDeclared(DeclaredType t, Void __) {
                if (this.visited.contains(t)) {
                    return Stream.empty();
                }
                this.visited.add(t);
                Stream<DeclaredType> ret = this.depth == 0 ? Stream.empty() : Stream.of(t);
                try {
                    ++this.depth;
                    if (this.depth == 1) {
                        for (TypeMirror typeMirror : t.getTypeArguments()) {
                            ret = Stream.concat(ret, (Stream)this.visit(typeMirror, null));
                        }
                        for (TypeMirror typeMirror : insp.directSupertypes(t)) {
                            ret = Stream.concat(ret, (Stream)this.visit(typeMirror, null));
                        }
                        TypeElement type = (TypeElement)t.asElement();
                        Stream<DeclaredType> stream = this.modelledUses(type);
                        Stream<DeclaredType> stream2 = stream == null ? null : Stream.concat(ret, stream);
                        return stream2;
                    }
                    Stream<DeclaredType> stream = ret;
                    return stream;
                }
                finally {
                    --this.depth;
                }
            }

            @Override
            public Stream<DeclaredType> visitError(ErrorType t, Void __) {
                return this.visitDeclared((DeclaredType)t, null);
            }

            @Override
            public Stream<DeclaredType> visitTypeVariable(TypeVariable t, Void __) {
                return this.nest(() -> (Stream)this.visit(t.getUpperBound(), null));
            }

            @Override
            public Stream<DeclaredType> visitWildcard(WildcardType t, Void __) {
                return this.nest(() -> {
                    if (t.getSuperBound() != null) {
                        return (Stream)this.visit(t.getSuperBound(), null);
                    }
                    if (t.getExtendsBound() != null) {
                        return (Stream)this.visit(t.getExtendsBound(), null);
                    }
                    return (Stream)this.visit(insp.getJavaLangObjectElement().asType(), null);
                });
            }

            @Override
            public Stream<DeclaredType> visitExecutable(ExecutableType t, Void __) {
                return this.nest(() -> {
                    Stream retType = (Stream)this.visit(t.getReturnType(), null);
                    Stream paramTypes = t.getParameterTypes().stream().flatMap(p -> this.nest(() -> (Stream)this.visit((TypeMirror)p, null)));
                    Stream thrownTypes = t.getThrownTypes().stream().flatMap(e -> this.nest(() -> (Stream)this.visit((TypeMirror)e, null)));
                    Stream typeParamTypes = t.getTypeVariables().stream().flatMap(v -> this.nest(() -> (Stream)this.visit((TypeMirror)v, null)));
                    return Stream.concat(Stream.concat(Stream.concat(retType, paramTypes), thrownTypes), typeParamTypes);
                });
            }

            private Stream<DeclaredType> modelledUses(TypeElement t) {
                return insp.getUses(insp.fromElement(t)).stream().map(type -> (DeclaredType)insp.toMirror(type));
            }

            private <T> T nest(Supplier<T> fn) {
                try {
                    ++this.depth;
                    T t = fn.get();
                    return t;
                }
                finally {
                    --this.depth;
                }
            }
        };
    }

    static <M> TypeVisitor<Stream<Element>, ?> findUseSites(final ModelInspector<M> insp) {
        return new SimpleTypeVisitor8<Stream<Element>, Object>(Stream.empty()){
            private HashSet<DeclaredType> visited;
            {
                super(x0);
                this.visited = new HashSet();
            }

            @Override
            public Stream<Element> visitDeclared(DeclaredType t, Object o) {
                if (this.visited.contains(t)) {
                    return Stream.empty();
                }
                this.visited.add(t);
                Element el = t.asElement();
                Object model = insp.fromElement(el);
                Set useSites = insp.getUseSites(model);
                return useSites == null ? null : useSites.stream().map(insp::toElement);
            }
        };
    }
}

