/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.instance;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.NameMatch;
import org.revapi.classif.match.instance.TypeInstanceMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.Glob;
import org.revapi.classif.util.Globbed;

public final class FqnMatch
extends TypeInstanceMatch
implements Globbed {
    private final boolean matchAny;
    private final boolean matchAll;
    private final Glob<NameMatch> glob;

    public FqnMatch(List<NameMatch> names) {
        this.matchAny = names.size() == 1 && names.get(0).isMatchAny();
        this.matchAll = names.size() == 1 && names.get(0).isMatchAll();
        this.glob = !this.matchAny && !this.matchAll ? new Glob<NameMatch>(names) : null;
    }

    @Override
    public boolean isMatchAny() {
        return this.matchAny;
    }

    @Override
    public boolean isMatchAll() {
        return this.matchAll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <M> TestResult testAnyInstance(TypeMirror instantiation, MatchContext<M> ctx) {
        String fqn;
        if (this.glob == null) {
            return TestResult.PASSED;
        }
        if (instantiation instanceof DeclaredType) {
            fqn = ((TypeElement)((DeclaredType)instantiation).asElement()).getQualifiedName().toString();
            return this.glob.test((m, n) -> TestResult.fromBoolean(m.matches((String)n)), FqnMatch.split(fqn));
        } else if (instantiation instanceof PrimitiveType) {
            fqn = instantiation.toString();
            return this.glob.test((m, n) -> TestResult.fromBoolean(m.matches((String)n)), FqnMatch.split(fqn));
        } else {
            if (!(instantiation instanceof NoType)) return TestResult.NOT_PASSED;
            if (instantiation.getKind() != TypeKind.VOID) return TestResult.NOT_PASSED;
            fqn = "void";
        }
        return this.glob.test((m, n) -> TestResult.fromBoolean(m.matches((String)n)), FqnMatch.split(fqn));
    }

    public String toString() {
        return this.glob == null ? (this.matchAny ? "*" : "**") : this.glob.getMatches().stream().map(Object::toString).collect(Collectors.joining("."));
    }

    private static List<String> split(String fqn) {
        int to;
        int from = 0;
        ArrayList<String> ret = new ArrayList<String>(8);
        while ((to = fqn.indexOf(46, from)) != -1) {
            ret.add(fqn.substring(from, to));
            from = to + 1;
        }
        if (from == 0) {
            ret.add(fqn);
        } else if (from < fqn.length()) {
            ret.add(fqn.substring(from));
        }
        return ret;
    }
}

