/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.revapi.java.model.MissingTypeElement;
import org.revapi.java.spi.IgnoreCompletionFailures;

final class MissingTypeAwareDelegatingTypes
implements Types {
    private final Types types;

    public MissingTypeAwareDelegatingTypes(Types types) {
        this.types = types;
    }

    @Override
    public Element asElement(TypeMirror t) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::asElement, null), t);
    }

    @Override
    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::isSameType, Boolean.valueOf(false)), t1, t2);
    }

    @Override
    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::isSubtype, Boolean.valueOf(false)), t1, t2);
    }

    @Override
    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::isAssignable, Boolean.valueOf(false)), t1, t2);
    }

    @Override
    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::contains, Boolean.valueOf(false)), t1, t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::isSubsignature, Boolean.valueOf(false)), m1, m2);
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::directSupertypes, Collections.emptyList()), t);
    }

    @Override
    public TypeMirror erasure(TypeMirror t) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::erasure, t), t);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return IgnoreCompletionFailures.in(this.types::boxedClass, p);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror t) {
        if (MissingTypeElement.isMissing(t)) {
            throw new IllegalArgumentException("Type " + t + " does not have an unboxing conversion.");
        }
        return IgnoreCompletionFailures.in(this.types::unboxedType, t);
    }

    @Override
    public TypeMirror capture(TypeMirror t) {
        return IgnoreCompletionFailures.in(MissingTypeAwareDelegatingTypes.checkMissing(this.types::capture, t), t);
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.types.getPrimitiveType(kind);
    }

    @Override
    public NullType getNullType() {
        return this.types.getNullType();
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        return this.types.getNoType(kind);
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        if (MissingTypeElement.isMissing(componentType)) {
            throw new IllegalArgumentException("Type " + componentType + " is not a valid component of an array.");
        }
        return IgnoreCompletionFailures.in(this.types::getArrayType, componentType);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        if (MissingTypeElement.isMissing(extendsBound) || MissingTypeElement.isMissing(superBound)) {
            throw new IllegalArgumentException("Invalid bounds.");
        }
        return IgnoreCompletionFailures.in(this.types::getWildcardType, extendsBound, superBound);
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        if (MissingTypeElement.isMissing(typeElem)) {
            throw new IllegalArgumentException("Invalid type element.");
        }
        for (TypeMirror t : typeArgs) {
            if (!MissingTypeElement.isMissing(t)) continue;
            throw new IllegalArgumentException("Invalid type arguments.");
        }
        return IgnoreCompletionFailures.in(this.types::getDeclaredType, typeElem, typeArgs);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        if (MissingTypeElement.isMissing(containing)) {
            throw new IllegalArgumentException("Invalid containing type.");
        }
        if (MissingTypeElement.isMissing(typeElem)) {
            throw new IllegalArgumentException("Invalid type element.");
        }
        for (TypeMirror t : typeArgs) {
            if (!MissingTypeElement.isMissing(t)) continue;
            throw new IllegalArgumentException("Invalid type arguments.");
        }
        return IgnoreCompletionFailures.in(this.types::getDeclaredType, containing, typeElem, typeArgs);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        if (MissingTypeElement.isMissing(containing)) {
            throw new IllegalArgumentException("Invalid containing type.");
        }
        if (MissingTypeElement.isMissing(element)) {
            throw new IllegalArgumentException("Invalid element.");
        }
        return IgnoreCompletionFailures.in(this.types::asMemberOf, containing, element);
    }

    private static <R, T extends TypeMirror> IgnoreCompletionFailures.Fn1<R, T> checkMissing(Function<T, R> fn, R returnValueOnMissing) {
        return t -> {
            if (MissingTypeElement.isMissing(t)) {
                return returnValueOnMissing;
            }
            return fn.apply(t);
        };
    }

    private static <R, T1 extends TypeMirror, T2 extends TypeMirror> IgnoreCompletionFailures.Fn2<R, T1, T2> checkMissing(BiFunction<T1, T2, R> fn, R returnValueOnMissing) {
        return (t1, t2) -> {
            if (MissingTypeElement.isMissing(t1) || MissingTypeElement.isMissing(t2)) {
                return returnValueOnMissing;
            }
            return fn.apply(t1, t2);
        };
    }
}

