/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.instance;

import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.Match;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.LogUtil;

public abstract class TypeInstanceMatch
extends Match {
    private static final Logger LOG = LogManager.getLogger(TypeInstanceMatch.class);
    private final TypeVisitor<TestResult, MatchContext<?>> dispatcher = new SimpleTypeVisitor8<TestResult, MatchContext<?>>(){

        @Override
        public TestResult visitIntersection(IntersectionType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testIntersection(t, matchContext);
        }

        @Override
        public TestResult visitUnion(UnionType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testUnion(t, matchContext);
        }

        @Override
        protected TestResult defaultAction(TypeMirror e, MatchContext<?> matchContext) {
            return TestResult.NOT_PASSED;
        }

        @Override
        public TestResult visitPrimitive(PrimitiveType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testPrimitive(t, matchContext);
        }

        @Override
        public TestResult visitNull(NullType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testNull(t, matchContext);
        }

        @Override
        public TestResult visitArray(ArrayType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testArray(t, matchContext);
        }

        @Override
        public TestResult visitDeclared(DeclaredType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testDeclared(t, matchContext);
        }

        @Override
        public TestResult visitError(ErrorType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testError(t, matchContext);
        }

        @Override
        public TestResult visitTypeVariable(TypeVariable t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testTypeVariable(t, matchContext);
        }

        @Override
        public TestResult visitWildcard(WildcardType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testWildcard(t, matchContext);
        }

        @Override
        public TestResult visitExecutable(ExecutableType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testExecutable(t, matchContext);
        }

        @Override
        public TestResult visitNoType(NoType t, MatchContext<?> matchContext) {
            return TypeInstanceMatch.this.testNoType(t, matchContext);
        }
    };

    @Override
    public final <M> TestResult testDeclaration(Element declaration, TypeMirror instance, MatchContext<M> ctx) {
        return TestResult.NOT_PASSED;
    }

    @Override
    public final <M> TestResult testInstance(TypeMirror instance, MatchContext<M> ctx) {
        return LOG.traceExit(LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "instance", (Object)instance, "ctx", ctx)), this.testAnyInstance(instance, ctx));
    }

    protected <M> TestResult testAnyInstance(TypeMirror instance, MatchContext<M> ctx) {
        return this.dispatcher.visit(instance, ctx);
    }

    protected <M> TestResult testIntersection(IntersectionType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testUnion(UnionType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult defaultTest(TypeMirror e, MatchContext<M> matchContext) {
        return TestResult.NOT_PASSED;
    }

    protected <M> TestResult testPrimitive(PrimitiveType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testNull(NullType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testArray(ArrayType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testDeclared(DeclaredType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testError(ErrorType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testTypeVariable(TypeVariable t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testWildcard(WildcardType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testExecutable(ExecutableType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }

    protected <M> TestResult testNoType(NoType t, MatchContext<M> matchContext) {
        return this.defaultTest(t, matchContext);
    }
}

