/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.statement;

import java.util.List;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.AnnotationsMatch;
import org.revapi.classif.match.declaration.ModifiersMatch;
import org.revapi.classif.match.declaration.TypeConstraintsMatch;
import org.revapi.classif.match.declaration.TypeKindMatch;
import org.revapi.classif.match.instance.FqnMatch;
import org.revapi.classif.match.instance.TypeParametersMatch;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.statement.AbstractStatement;

public final class TypeDefinitionStatement
extends AbstractStatement {
    private final TypeKindMatch typeKind;
    private final FqnMatch fqn;
    private final TypeParametersMatch typeParameters;
    private final TypeConstraintsMatch constraints;

    public TypeDefinitionStatement(String definedVariable, List<String> referencedVariables, AnnotationsMatch annotations, ModifiersMatch modifiers, TypeKindMatch typeKind, FqnMatch fqn, TypeParametersMatch typeParameters, TypeConstraintsMatch constraints, boolean negation, boolean isMatch) {
        super(definedVariable, referencedVariables, isMatch, annotations, modifiers, negation);
        this.typeKind = typeKind;
        this.fqn = fqn;
        this.typeParameters = typeParameters;
        this.constraints = constraints;
    }

    @Override
    public <M> StatementMatch<M> createMatch() {
        return new StatementMatch<M>(){

            @Override
            public TestResult testType(M type, MatchContext<M> ctx) {
                TestResult ret = TypeDefinitionStatement.this.annotations.test(type, ctx).and(() -> TypeDefinitionStatement.this.modifiers.test(type, ctx)).and(() -> TypeDefinitionStatement.this.typeKind.test(type, ctx)).and(() -> TypeDefinitionStatement.this.fqn.test(type, ctx));
                if (TypeDefinitionStatement.this.typeParameters != null) {
                    ret = ret.and(() -> TypeDefinitionStatement.this.typeParameters.test(type, ctx));
                }
                if (TypeDefinitionStatement.this.constraints != null) {
                    ret = ret.and(() -> TypeDefinitionStatement.this.constraints.test(type, ctx));
                }
                return TypeDefinitionStatement.this.negation ? ret.negate() : ret;
            }

            @Override
            public String toString() {
                StringBuilder bld = new StringBuilder(TypeDefinitionStatement.this.toStringPrefix());
                bld.append(TypeDefinitionStatement.this.typeKind.toString()).append(" ");
                if (TypeDefinitionStatement.this.isMatch()) {
                    bld.append("^");
                }
                TypeDefinitionStatement.this.insertVariable(bld);
                if (TypeDefinitionStatement.this.negation) {
                    bld.append("!");
                }
                bld.append(TypeDefinitionStatement.this.fqn);
                if (TypeDefinitionStatement.this.typeParameters != null) {
                    bld.append("<");
                    bld.append(TypeDefinitionStatement.this.typeParameters);
                    bld.append(">");
                }
                if (TypeDefinitionStatement.this.constraints != null) {
                    bld.append(" ");
                    bld.append(TypeDefinitionStatement.this.constraints);
                }
                return bld.toString();
            }
        };
    }
}

