/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class TreeNode<This extends TreeNode<This>>
implements Cloneable {
    private This parent;
    private ParentPreservingSet children = new ParentPreservingSet();

    public This getParent() {
        return this.parent;
    }

    public void setParent(This parent) {
        this.parent = parent;
        if (parent != null) {
            ((TreeNode)parent)._getChildren()._add(this.castThis());
        }
    }

    void _setParent(This parent) {
        this.parent = parent;
    }

    ParentPreservingSet _getChildren() {
        return this.children;
    }

    public Set<This> getChildren() {
        return this.children;
    }

    public This clone() {
        try {
            return (This)((TreeNode)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Cloneable is implemented by failed.");
        }
    }

    private This castThis() {
        return (This)this;
    }

    private class ParentPreservingSet
    implements Set<This>,
    Cloneable {
        private Set<This> actual = new HashSet();

        private ParentPreservingSet() {
        }

        @Override
        public int size() {
            return this.actual.size();
        }

        @Override
        public boolean isEmpty() {
            return this.actual.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.actual.contains(o);
        }

        @Override
        public Iterator<This> iterator() {
            return new ParentPreservingIterator(this.actual.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.actual.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.actual.toArray(a);
        }

        public void _add(This t) {
            this.actual.add(t);
        }

        @Override
        public boolean add(This t) {
            boolean ret = this.actual.add(t);
            if (ret) {
                t._setParent((TreeNode)TreeNode.this.castThis());
            }
            return ret;
        }

        @Override
        public boolean remove(Object o) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                TreeNode e = (TreeNode)it.next();
                if ((o != null || e != null) && (o == null || !o.equals(e))) continue;
                it.remove();
                if (e != null) {
                    e._setParent(null);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.actual.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends This> c) {
            for (TreeNode e : c) {
                this.add((This)e);
            }
            return !c.isEmpty();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean ret = false;
            for (Object o : c) {
                if (this.contains(o)) continue;
                ret = true;
                this.remove(o);
            }
            return ret;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean ret = false;
            for (Object o : c) {
                ret |= this.remove(o);
            }
            return ret;
        }

        @Override
        public void clear() {
            for (TreeNode e : this) {
                e.setParent(null);
            }
            this.actual.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.actual.equals(o);
        }

        @Override
        public int hashCode() {
            return this.actual.hashCode();
        }

        private class ParentPreservingIterator
        implements Iterator<This> {
            private final Iterator<This> it;
            This last;

            private ParentPreservingIterator(Iterator<This> it) {
                this.it = it;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public This next() {
                this.last = (TreeNode)this.it.next();
                return this.last;
            }

            @Override
            public void remove() {
                this.it.remove();
                if (this.last != null) {
                    ((TreeNode)this.last).setParent(null);
                }
            }
        }
    }
}

