/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.dsl;

final class ErrorFormatter {
    private ErrorFormatter() {
    }

    static String formatError(String recipe, int line, int col, String errorMessage) {
        String[] lines = recipe.split("\r?\n");
        StringBuilder sb = new StringBuilder("\n");
        int maxDigits = ErrorFormatter.getNumberOfDigits(lines.length + 1);
        int maxLineLength = ErrorFormatter.maxLineLength(lines) + maxDigits + 3;
        int curLine = 0;
        int beforeLine = line - 1;
        while (curLine <= beforeLine) {
            ErrorFormatter.appendLineNo(sb, curLine + 1, maxDigits);
            sb.append(lines[curLine++]).append("\n");
        }
        int charsUntilCol = col + maxDigits + 3;
        ErrorFormatter.appendNTimes(sb, '-', charsUntilCol);
        sb.append('^');
        ErrorFormatter.appendNTimes(sb, '-', maxLineLength - charsUntilCol - 1);
        sb.append("\n");
        ErrorFormatter.appendNTimes(sb, ' ', col + maxDigits + 3);
        sb.append("|\n");
        sb.append(errorMessage).append("\n");
        ErrorFormatter.appendNTimes(sb, '-', maxLineLength);
        sb.append("\n");
        while (curLine < lines.length) {
            ErrorFormatter.appendLineNo(sb, curLine + 1, maxDigits);
            sb.append(lines[curLine++]).append("\n");
        }
        return sb.toString();
    }

    private static void appendLineNo(StringBuilder sb, int lineNo, int maxDigits) {
        int lineDigits = ErrorFormatter.getNumberOfDigits(lineNo);
        while (lineDigits++ < maxDigits) {
            sb.append(" ");
        }
        sb.append(lineNo);
        sb.append(" | ");
    }

    private static void appendNTimes(StringBuilder sb, char str, int nofTimes) {
        int i = 0;
        while (i++ < nofTimes) {
            sb.append(str);
        }
    }

    private static int maxLineLength(String[] lines) {
        int max = 0;
        for (String l : lines) {
            int len = l.length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    private static int getNumberOfDigits(int positive) {
        if (positive < 100000) {
            if (positive < 100) {
                return positive < 10 ? 1 : 2;
            }
            if (positive < 1000) {
                return 3;
            }
            if (positive < 10000) {
                return 4;
            }
            return 5;
        }
        if (positive < 10000000) {
            return positive < 1000000 ? 6 : 7;
        }
        if (positive < 100000000) {
            return 8;
        }
        if (positive < 1000000000) {
            return 9;
        }
        return 10;
    }
}

