/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.progress;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.revapi.classif.ModelInspector;
import org.revapi.classif.StructuralMatcher;
import org.revapi.classif.TestResult;
import org.revapi.classif.progress.MultiMatchingProgress;
import org.revapi.classif.progress.SimpleMatchingProgress;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.WalkInstruction;
import org.revapi.classif.progress.context.StatementContext;
import org.revapi.classif.util.LogUtil;
import org.revapi.classif.util.SizedCollections;
import org.revapi.classif.util.execution.DependencyGraph;
import org.revapi.classif.util.execution.Node;
import org.revapi.classif.util.execution.StatementWrapper;

public abstract class MatchingProgress<M> {
    private static final Logger LOG = LogManager.getLogger(MatchingProgress.class);

    public static <M> MatchingProgress<M> of(DependencyGraph matchGraph, ModelInspector<M> modelInspector, StructuralMatcher.Configuration configuration) {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "configuration", (Object)configuration, "matchGraph", (Object)matchGraph));
        if (matchGraph.getAllNodes().size() == 1) {
            return LOG.traceExit(methodTrace, new SimpleMatchingProgress<M>(configuration, MatchingProgress.convert(matchGraph.getAllNodes().iterator().next(), modelInspector, new HashMap<Node<StatementWrapper>, Node<StatementMatch<M>>>()).getObject()));
        }
        IdentityHashMap cache = SizedCollections.newIdentityHashMapWithExactSize(matchGraph.getAllNodes().size());
        return LOG.traceExit(methodTrace, new MultiMatchingProgress(configuration, matchGraph.getAllNodes().stream().map(n -> MatchingProgress.convert(n, modelInspector, cache)).collect(SizedCollections.toListWithSize(matchGraph.getAllNodes().size()))));
    }

    MatchingProgress() {
    }

    public abstract WalkInstruction start(M var1);

    public abstract TestResult finish(M var1);

    public abstract Map<M, TestResult> finish();

    public abstract void reset();

    private static <M> Node<StatementMatch<M>> convert(Node<StatementWrapper> n, ModelInspector<M> inspector, Map<Node<StatementWrapper>, Node<StatementMatch<M>>> cache) {
        Node<StatementMatch<M>> ret = cache.get(n);
        if (ret != null) {
            return ret;
        }
        StatementWrapper wrapper = n.getObject();
        ret = new Node(wrapper.getStatement().createMatch());
        cache.put(n, ret);
        IdentityHashMap<Node<StatementWrapper>, Node<StatementMatch<M>>> ins = SizedCollections.newIdentityHashMapWithExactSize(n.in().size());
        IdentityHashMap<Node<StatementWrapper>, Node<StatementMatch<M>>> outs = SizedCollections.newIdentityHashMapWithExactSize(n.out().size());
        IdentityHashMap<Node<StatementWrapper>, Node<StatementMatch<M>>> children = SizedCollections.newIdentityHashMapWithExactSize(n.getChildren().size());
        for (Node<StatementWrapper> in : n.in()) {
            ins.put(in, MatchingProgress.convert(in, inspector, cache));
        }
        for (Node<StatementWrapper> out : n.out()) {
            outs.put(out, MatchingProgress.convert(out, inspector, cache));
        }
        for (Node<StatementWrapper> c : n.getChildren()) {
            children.put(c, MatchingProgress.convert(c, inspector, cache));
        }
        ret.in().addAll(ins.values());
        ret.out().addAll(outs.values());
        ret.getChildren().addAll(children.values());
        int nofReferencedVariables = n.in().size();
        HashSet<String> referencedStatements = nofReferencedVariables == 0 ? Collections.emptySet() : new HashSet<String>(nofReferencedVariables);
        for (String v : n.getObject().getStatement().getReferencedVariables()) {
            StatementMatch referencedMatch = (StatementMatch)n.in().stream().filter(o -> v.equals(((StatementWrapper)o.getObject()).getStatement().getDefinedVariable())).map(ins::get).findFirst().orElseThrow(() -> new IllegalStateException("Invalid dependency graph. Could not find a node defining variable " + v)).getObject();
            referencedStatements.add(v);
        }
        ret.getObject().setContext(new StatementContext<M>(inspector, wrapper.isReturn(), wrapper.getStatement().getDefinedVariable(), referencedStatements));
        return ret;
    }
}

