/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.progress;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor8;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.revapi.classif.TestResult;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.progress.context.StatementContext;
import org.revapi.classif.util.LogUtil;

public abstract class StatementMatch<M> {
    private static final Logger LOG = LogManager.getLogger(StatementMatch.class);
    private StatementContext<M> ctx;
    private Map<M, TestResult> matchCandidates = new HashMap<M, TestResult>();

    protected StatementContext<M> getContext() {
        return this.ctx;
    }

    public void setContext(StatementContext<M> ctx) {
        this.ctx = ctx;
    }

    public void reset() {
        this.matchCandidates = new HashMap<M, TestResult>();
    }

    public final TestResult test(M model, MatchContext<M> ctx) {
        return this.forwardTest(model, ctx, this.tester(model, ctx));
    }

    public TestResult independentTest(M model) {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "model", model));
        MatchContext<M> ctx = this.getContext().getMatchContext();
        TestResult ret = this.forwardTest(model, ctx, this.tester(model, ctx));
        if (ret == TestResult.PASSED) {
            this.matchCandidates.put(model, ret);
        }
        return LOG.traceExit(methodTrace, ret);
    }

    public Set<M> getCandidates() {
        return this.matchCandidates.keySet();
    }

    public String toString() {
        return "StatementMatch{ctx=" + this.ctx + '}';
    }

    protected TestResult testType(M type, MatchContext<M> ctx) {
        return this.defaultElementTest(type, ctx);
    }

    protected TestResult testMethod(M method, MatchContext<M> ctx) {
        return this.defaultElementTest(method, ctx);
    }

    protected TestResult testVariable(M var, MatchContext<M> ctx) {
        return this.defaultElementTest(var, ctx);
    }

    protected TestResult defaultElementTest(M model, MatchContext<M> ctx) {
        return TestResult.NOT_PASSED;
    }

    private TestResult forwardTest(M model, MatchContext<M> ctx, ElementVisitor<TestResult, MatchContext<M>> tester) {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "model", model, "ctx", ctx));
        return LOG.traceExit(methodTrace, tester.visit(ctx.getModelInspector().toElement(model), ctx));
    }

    private ElementVisitor<TestResult, MatchContext<M>> tester(final M model, MatchContext<M> ctx) {
        return new SimpleElementVisitor8<TestResult, MatchContext<M>>(){

            @Override
            protected TestResult defaultAction(Element e, MatchContext<M> ctx) {
                return TestResult.NOT_PASSED;
            }

            @Override
            public TestResult visitVariable(VariableElement e, MatchContext<M> ctx) {
                return StatementMatch.this.testVariable(model, ctx);
            }

            @Override
            public TestResult visitType(TypeElement e, MatchContext<M> ctx) {
                return StatementMatch.this.testType(model, ctx);
            }

            @Override
            public TestResult visitExecutable(ExecutableElement e, MatchContext<M> ctx) {
                return StatementMatch.this.testMethod(model, ctx);
            }
        };
    }
}

