/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.statement;

import java.util.List;
import org.revapi.classif.match.declaration.AnnotationsMatch;
import org.revapi.classif.match.declaration.ModifiersMatch;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.context.StatementContext;
import org.revapi.classif.util.TreeNode;

public abstract class AbstractStatement
extends TreeNode<AbstractStatement> {
    protected final AnnotationsMatch annotations;
    protected final ModifiersMatch modifiers;
    protected final boolean negation;
    private final String definedVariable;
    private final List<String> referencedVariables;
    private final boolean isMatch;

    protected AbstractStatement(String definedVariable, List<String> referencedVariables, boolean isMatch, AnnotationsMatch annotations, ModifiersMatch modifiers, boolean negation) {
        this.definedVariable = definedVariable;
        this.referencedVariables = referencedVariables;
        this.isMatch = isMatch;
        this.annotations = annotations;
        this.modifiers = modifiers;
        this.negation = negation;
    }

    public String getDefinedVariable() {
        return this.definedVariable;
    }

    public List<String> getReferencedVariables() {
        return this.referencedVariables;
    }

    public boolean isMatch() {
        return this.isMatch;
    }

    public abstract <M> StatementMatch<M> createMatch();

    public final <M> StatementMatch<M> createMatch(StatementContext<M> ctx) {
        StatementMatch<M> m = this.createMatch();
        m.setContext(ctx);
        return m;
    }

    protected String toStringPrefix() {
        return this.annotations.toString() + (this.annotations.isEmpty() ? "" : " ") + this.modifiers.toString() + (this.modifiers.isEmpty() ? "" : " ");
    }

    protected void insertVariable(StringBuilder bld) {
        if (this.definedVariable != null) {
            if (bld.length() > 0) {
                bld.append(" ");
            }
            bld.append("%").append(this.definedVariable).append("=");
        }
    }

    public String toString() {
        return this.createMatch().toString();
    }
}

