/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.util.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.revapi.classif.statement.AbstractStatement;
import org.revapi.classif.util.execution.Node;
import org.revapi.classif.util.execution.StatementWrapper;

public final class DependencyGraph {
    private final Collection<Node<StatementWrapper>> allNodes;

    public DependencyGraph(List<String> namedMatches, List<AbstractStatement> statements) throws IllegalArgumentException {
        this.allNodes = DependencyGraph.initMatches(namedMatches == null ? Collections.emptyList() : namedMatches, statements, new HashMap<String, Node<StatementWrapper>>(), new HashMap<String, List<Node<StatementWrapper>>>());
    }

    public Collection<Node<StatementWrapper>> getAllNodes() {
        return this.allNodes;
    }

    public String toString() {
        return this.allNodes.stream().filter(n -> n.getParent() == null).map(Object::toString).collect(Collectors.joining("\n\n"));
    }

    private static Collection<Node<StatementWrapper>> initMatches(List<String> namedMatches, Collection<AbstractStatement> statements, Map<String, Node<StatementWrapper>> definers, Map<String, List<Node<StatementWrapper>>> referencers) {
        ArrayList<Node<StatementWrapper>> rootNodes = new ArrayList<Node<StatementWrapper>>(4);
        DependencyGraph.collectVariables(namedMatches, null, statements, rootNodes, definers, referencers);
        Collection<Node<StatementWrapper>> ret = DependencyGraph.createGraph(rootNodes, definers, referencers);
        if (DependencyGraph.isCyclic(ret)) {
            throw new IllegalArgumentException("The statements' variables create a cyclic graph. This is not supported.");
        }
        return ret;
    }

    private static <T> boolean isCyclic(Collection<Node<T>> nodes) {
        return nodes.stream().map(n -> DependencyGraph.isCyclic(n, new HashSet())).reduce(false, Boolean::logicalOr);
    }

    private static boolean isCyclic(Node<?> node, Set<Node<?>> currentTraversal) {
        if (currentTraversal.contains(node)) {
            return true;
        }
        currentTraversal.add(node);
        boolean ret = false;
        for (Node<?> child : node.out()) {
            if (!DependencyGraph.isCyclic(child, currentTraversal)) continue;
            ret = true;
            break;
        }
        currentTraversal.remove(node);
        return ret;
    }

    private static void collectVariables(List<String> namedMatches, Node<StatementWrapper> parent, Collection<AbstractStatement> statements, List<Node<StatementWrapper>> rootNodes, Map<String, Node<StatementWrapper>> definers, Map<String, List<Node<StatementWrapper>>> referencers) {
        Iterator<AbstractStatement> iterator = statements.iterator();
        while (iterator.hasNext()) {
            AbstractStatement st;
            StatementWrapper match = new StatementWrapper(st, (st = iterator.next()).isMatch() || namedMatches.contains(st.getDefinedVariable()));
            Node<StatementWrapper> node = new Node<StatementWrapper>(match);
            node.setParent(parent);
            if (parent == null) {
                rootNodes.add(node);
            }
            if (st.getDefinedVariable() != null) {
                definers.put(st.getDefinedVariable(), node);
            }
            st.getReferencedVariables().forEach(v -> referencers.computeIfAbsent((String)v, __ -> new ArrayList()).add(node));
            DependencyGraph.collectVariables(namedMatches, node, st.getChildren(), rootNodes, definers, referencers);
        }
    }

    private static Collection<Node<StatementWrapper>> createGraph(List<Node<StatementWrapper>> rootNodes, Map<String, Node<StatementWrapper>> definers, Map<String, List<Node<StatementWrapper>>> referencers) {
        definers.forEach((name, node) -> referencers.getOrDefault(name, Collections.emptyList()).forEach(refNode -> {
            node.out().add(refNode);
            refNode.in().add(node);
        }));
        HashSet<Node<StatementWrapper>> ret = new HashSet<Node<StatementWrapper>>();
        DependencyGraph.addAllRecursively(rootNodes, ret);
        return ret;
    }

    private static <T> void addAllRecursively(Collection<Node<T>> nodes, Collection<Node<T>> all) {
        for (Node<T> n : nodes) {
            all.add(n);
            DependencyGraph.addAllRecursively(n.getChildren(), all);
        }
    }
}

