/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaFieldElement;

public class EnumConstantsOrderChanged
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    private boolean shouldCheck(JavaFieldElement oldField, JavaFieldElement newField) {
        return this.isBothAccessible(oldField, newField) && oldField.getDeclaringElement().getKind() == ElementKind.ENUM_CONSTANT && newField.getDeclaringElement().getKind() == ElementKind.ENUM_CONSTANT;
    }

    @Override
    protected void doVisitField(@Nullable JavaFieldElement oldField, @Nullable JavaFieldElement newField) {
        if (!this.shouldCheck(oldField, newField)) {
            return;
        }
        Predicate<VariableElement> isNotEnumConstant = v -> v.getKind() != ElementKind.ENUM_CONSTANT;
        List<VariableElement> fields = ElementFilter.fieldsIn(oldField.getDeclaringElement().getEnclosingElement().getEnclosedElements());
        fields.removeIf(isNotEnumConstant);
        int oldIdx = fields.indexOf(oldField.getDeclaringElement());
        fields = ElementFilter.fieldsIn(newField.getDeclaringElement().getEnclosingElement().getEnclosedElements());
        fields.removeIf(isNotEnumConstant);
        int newIdx = fields.indexOf(newField.getDeclaringElement());
        if (newIdx != oldIdx) {
            this.pushActive(oldField, newField, oldIdx, newIdx);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        String oldIdx = fields.context[0].toString();
        String newIdx = fields.context[1].toString();
        return Collections.singletonList(this.createDifference(Code.FIELD_ENUM_CONSTANT_ORDER_CHANGED, Code.attachmentsFor((JavaFieldElement)fields.oldElement, (JavaFieldElement)fields.newElement, "oldOrdinal", oldIdx, "newOrdinal", newIdx)));
    }
}

