/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.Util;

public final class Varargs
extends CheckBase {
    private boolean reportUnchanged;

    @Override
    public void initialize(@Nonnull AnalysisContext analysisContext) {
        super.initialize(analysisContext);
        JsonNode reportUnchanged = analysisContext.getConfigurationNode().path("reportUnchanged");
        this.reportUnchanged = reportUnchanged.asBoolean(true);
    }

    @Override
    @Nullable
    public String getExtensionId() {
        return "varargOverloadsOnlyDifferInVarargParameter";
    }

    @Override
    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/META-INF/vararg-overloads-config-schema.json")), StandardCharsets.UTF_8);
    }

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    @Override
    protected void doVisitMethod(JavaMethodElement oldMethod, JavaMethodElement newMethod) {
        if (newMethod != null && newMethod.getDeclaringElement().isVarArgs() && (this.reportUnchanged || oldMethod == null || !Util.toUniqueString(oldMethod.getModelRepresentation()).equals(Util.toUniqueString(newMethod.getModelRepresentation())))) {
            this.pushActive(oldMethod, newMethod, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        JavaMethodElement method = (JavaMethodElement)methods.newElement;
        List<? extends TypeMirror> methodParams = method.getModelRepresentation().getParameterTypes();
        Types types = method.getTypeEnvironment().getTypeUtils();
        List methodsDifferingOnlyInVarargType = this.getOverloads(method).filter(m -> {
            if (!m.getDeclaringElement().isVarArgs()) {
                return false;
            }
            List<? extends TypeMirror> thisParams = m.getModelRepresentation().getParameterTypes();
            if (thisParams.size() != methodParams.size()) {
                return false;
            }
            for (int i = 0; i < methodParams.size() - 1; ++i) {
                if (types.isSameType((TypeMirror)methodParams.get(i), thisParams.get(i))) continue;
                return false;
            }
            return !types.isSameType((TypeMirror)methodParams.get(methodParams.size() - 1), thisParams.get(thisParams.size() - 1));
        }).collect(Collectors.toList());
        if (!methodsDifferingOnlyInVarargType.isEmpty()) {
            return Collections.singletonList(this.createDifferenceWithExplicitParams(Code.METHOD_VARARG_OVERLOADS_ONLY_DIFFER_IN_VARARG_PARAMETER, Code.attachmentsFor((JavaMethodElement)methods.oldElement, method, new String[0]), methodsDifferingOnlyInVarargType.toString()));
        }
        return null;
    }

    private Stream<JavaMethodElement> getOverloads(JavaMethodElement method) {
        return method.getParent().stream(JavaMethodElement.class, false).filter(m -> m.getDeclaringElement().getSimpleName().toString().equals(method.getDeclaringElement().getSimpleName().toString()));
    }
}

