/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.revapi.Difference;
import org.revapi.java.checks.common.VisibilityChanged;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;

public final class VisibilityReduced
extends VisibilityChanged {
    public VisibilityReduced() {
        super(Code.METHOD_VISIBILITY_REDUCED, false);
    }

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    @Override
    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        this.doVisit(oldMethod, newMethod);
    }

    @Override
    protected Difference report(CheckBase.ActiveElements<?> els, Modifier oldVisibility, Modifier newVisibility) {
        JavaMethodElement oldMethod = (JavaMethodElement)els.oldElement;
        JavaMethodElement newMethod = (JavaMethodElement)els.newElement;
        if (oldMethod != null && oldMethod.getDeclaringElement().getKind() == ElementKind.CONSTRUCTOR && newMethod != null && oldVisibility == Modifier.PUBLIC && newVisibility == Modifier.PROTECTED) {
            return this.createDifference(Code.METHOD_PUBLIC_CONSTRUCTOR_OF_ABSTRACT_CLASS_NOW_PROTECTED, Code.attachmentsFor(els.oldElement, els.newElement, new String[0]));
        }
        return super.report(els, oldVisibility, newVisibility);
    }
}

