/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.methods;

import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;

public final class AnnotationTypeAttributeAdded
implements DifferenceTransform<JavaMethodElement> {
    private Locale locale;
    private final Pattern[] codes = new Pattern[]{Pattern.compile("^" + Pattern.quote(Code.METHOD_ABSTRACT_METHOD_ADDED.code()) + "$")};
    private final List<Predicate<String>> predicates = Collections.singletonList(Code.METHOD_ABSTRACT_METHOD_ADDED.code()::equals);

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nonnull
    public List<Predicate<String>> getDifferenceCodePredicates() {
        return this.predicates;
    }

    @Nullable
    public String getExtensionId() {
        return "revapi.java.annotationTypeAttributeAdded";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.locale = analysisContext.getLocale();
    }

    @Nullable
    public Difference transform(@Nullable JavaMethodElement oldElement, @Nullable JavaMethodElement newElement, @Nonnull Difference difference) {
        ExecutableElement method = newElement.getDeclaringElement();
        if (method.getEnclosingElement().getKind() == ElementKind.ANNOTATION_TYPE) {
            AnnotationValue defaultValue = method.getDefaultValue();
            if (defaultValue == null) {
                return Code.METHOD_ATTRIBUTE_WITH_NO_DEFAULT_ADDED_TO_ANNOTATION_TYPE.createDifference(this.locale, new LinkedHashMap<String, String>(difference.attachments));
            }
            return Code.METHOD_ATTRIBUTE_WITH_DEFAULT_ADDED_TO_ANNOTATION_TYPE.createDifference(this.locale, new LinkedHashMap<String, String>(difference.attachments));
        }
        return difference;
    }

    public void close() {
    }
}

