/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Types;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.ApiAnalyzer;
import org.revapi.ArchiveAnalyzer;
import org.revapi.CoIterator;
import org.revapi.CorrespondenceComparatorDeducer;
import org.revapi.DifferenceAnalyzer;
import org.revapi.Element;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.JavaArchiveAnalyzer;
import org.revapi.java.JavaElementDifferenceAnalyzer;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.Util;

public final class JavaApiAnalyzer
implements ApiAnalyzer {
    private final ExecutorService compilationExecutor = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private volatile int cnt;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Java API Compilation Thread #" + ++this.cnt);
        }
    });
    private AnalysisContext analysisContext;
    private AnalysisConfiguration configuration;
    private final Iterable<Check> checks;

    public JavaApiAnalyzer() {
        this(ServiceLoader.load(Check.class, JavaApiAnalyzer.class.getClassLoader()));
    }

    public JavaApiAnalyzer(Iterable<Check> checks) {
        this.checks = checks;
    }

    @Nonnull
    public CorrespondenceComparatorDeducer getCorrespondenceDeducer() {
        return (l1, l2) -> {
            if (l1.isEmpty() || l2.isEmpty()) {
                return Comparator.naturalOrder();
            }
            Element parent = ((Element)l1.get(0)).getParent();
            if (!(parent instanceof TypeElement)) {
                return Comparator.naturalOrder();
            }
            IdentityHashMap<MethodElement, Integer> c1MethodOrder = new IdentityHashMap<MethodElement, Integer>(l1.size());
            IdentityHashMap<MethodElement, Integer> c2MethodOrder = new IdentityHashMap<MethodElement, Integer>(l2.size());
            JavaApiAnalyzer.determineOrder(l1, l2, c1MethodOrder, c2MethodOrder);
            return (e1, e2) -> {
                int ret = JavaElementFactory.compareByType(e1, e2);
                if (ret != 0) {
                    return ret;
                }
                if (e1 instanceof MethodElement && e2 instanceof MethodElement) {
                    MethodElement m1 = (MethodElement)e1;
                    MethodElement m2 = (MethodElement)e2;
                    return (Integer)c1MethodOrder.get(m1) - (Integer)c2MethodOrder.get(m2);
                }
                return e1.compareTo(e2);
            };
        };
    }

    private static void determineOrder(List<Element> l1, List<Element> l2, IdentityHashMap<MethodElement, Integer> l1MethodOrder, IdentityHashMap<MethodElement, Integer> l2MethodOrder) {
        Element e;
        TreeMap<String, List<MethodElement>> l1MethodsByName = new TreeMap<String, List<MethodElement>>();
        TreeMap<String, List<MethodElement>> l2MethodsByName = new TreeMap<String, List<MethodElement>>();
        JavaApiAnalyzer.addAllMethods(l1, l1MethodsByName);
        JavaApiAnalyzer.addAllMethods(l2, l2MethodsByName);
        int index = 0;
        Iterator<Map.Entry<String, List<MethodElement>>> l1MethodsIterator = l1MethodsByName.entrySet().iterator();
        Iterator<Map.Entry<String, List<MethodElement>>> l2MethodsIterator = l2MethodsByName.entrySet().iterator();
        CoIterator coit = new CoIterator(l1MethodsIterator, l2MethodsIterator, (e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey()));
        ArrayList<MethodElement> l2MethodsInOrder = new ArrayList<MethodElement>();
        while (coit.hasNext()) {
            coit.next();
            Map.Entry l1e = (Map.Entry)coit.getLeft();
            Map.Entry l2e = (Map.Entry)coit.getRight();
            if (l1e == null) {
                for (MethodElement m : (List)l2e.getValue()) {
                    l2MethodOrder.put(m, index++);
                    l2MethodsInOrder.add(m);
                }
                continue;
            }
            if (l2e == null) {
                for (MethodElement m : (List)l1e.getValue()) {
                    l1MethodOrder.put(m, index++);
                }
                continue;
            }
            List l1Overloads = (List)l1e.getValue();
            List l2Overloads = (List)l2e.getValue();
            if (l1Overloads.size() == 1 && l2Overloads.size() == 1) {
                MethodElement m1 = (MethodElement)l1Overloads.get(0);
                MethodElement m2 = (MethodElement)l2Overloads.get(0);
                l2MethodsInOrder.add(m2);
                l2MethodOrder.put(m2, index);
                l1MethodOrder.put(m1, index++);
                continue;
            }
            for (MethodElement c1Method : l1Overloads) {
                MethodElement c2Method = JavaApiAnalyzer.removeBestMatch(c1Method, l2Overloads);
                if (c2Method != null) {
                    l2MethodOrder.put(c2Method, index);
                    l2MethodsInOrder.add(c2Method);
                }
                l1MethodOrder.put(c1Method, index++);
            }
            for (MethodElement m : l2Overloads) {
                l2MethodOrder.put(m, index++);
                l2MethodsInOrder.add(m);
            }
        }
        int methodRank = JavaElementFactory.getModelTypeRank(MethodElement.class);
        for (index = 0; index < l2.size() && JavaElementFactory.getModelTypeRank((e = l2.get(index)).getClass()) < methodRank; ++index) {
        }
        while (index < l2.size() && (e = l2.get(index)) instanceof MethodElement) {
            l2.remove(index);
        }
        l2.addAll(index, l2MethodsInOrder);
    }

    private static MethodElement removeBestMatch(MethodElement blueprint, List<MethodElement> candidates) {
        MethodElement best = null;
        float maxScore = 0.0f;
        int bestIdx = -1;
        List<String> fullBlueprintSignature = JavaApiAnalyzer.methodParamsSignature(blueprint, false);
        List<String> erasedBlueprintSignature = JavaApiAnalyzer.methodParamsSignature(blueprint, true);
        String fullBlueprintReturnType = Util.toUniqueString(((ExecutableElement)blueprint.getModelElement()).getReturnType());
        String erasedBlueprintReturnType = Util.toUniqueString(blueprint.getTypeEnvironment().getTypeUtils().erasure(((ExecutableElement)blueprint.getModelElement()).getReturnType()));
        int idx = 0;
        for (MethodElement candidate : candidates) {
            float score = JavaApiAnalyzer.computeMatchScore(fullBlueprintReturnType, fullBlueprintSignature, erasedBlueprintReturnType, erasedBlueprintSignature, candidate);
            if (maxScore <= score) {
                best = candidate;
                maxScore = score;
                bestIdx = idx;
            }
            ++idx;
        }
        if (bestIdx != -1) {
            candidates.remove(bestIdx);
        }
        return best;
    }

    private static List<String> methodParamsSignature(MethodElement method, boolean erased) {
        if (erased) {
            Types types = method.getTypeEnvironment().getTypeUtils();
            return ((ExecutableElement)method.getModelElement()).getParameters().stream().map(p -> Util.toUniqueString(types.erasure(p.asType()))).collect(Collectors.toList());
        }
        return ((ExecutableElement)method.getModelElement()).getParameters().stream().map(p -> Util.toUniqueString(p.asType())).collect(Collectors.toList());
    }

    private static float computeMatchScore(String blueprintReturnType, List<String> blueprintParamSignature, String erasedReturnType, List<String> erasedParamSignature, MethodElement method) {
        String mRt = Util.toUniqueString(((ExecutableElement)method.getModelElement()).getReturnType());
        String emRt = Util.toUniqueString(method.getTypeEnvironment().getTypeUtils().erasure(((ExecutableElement)method.getModelElement()).getReturnType()));
        List<String> mPs = JavaApiAnalyzer.methodParamsSignature(method, false);
        List<String> emPs = JavaApiAnalyzer.methodParamsSignature(method, true);
        int maxParams = Math.max(blueprintParamSignature.size(), mPs.size()) + 1;
        int commonParams = JavaApiAnalyzer.longestCommonSubsequenceLength(blueprintParamSignature, mPs, (blueprintIndex, methodIndex) -> {
            String fullBlueprintSig = (String)blueprintParamSignature.get((int)blueprintIndex);
            String erasedBlueprintSig = (String)erasedParamSignature.get((int)blueprintIndex);
            String fullMethodSig = (String)mPs.get((int)methodIndex);
            String erasedMethodSig = (String)emPs.get((int)methodIndex);
            if (fullBlueprintSig.equals(fullMethodSig)) {
                return 2;
            }
            if (erasedBlueprintSig.equals(erasedMethodSig)) {
                return 1;
            }
            return 0;
        });
        if (blueprintReturnType.equals(mRt)) {
            commonParams += 2;
        } else if (erasedReturnType.equals(emRt)) {
            ++commonParams;
        }
        if (maxParams == 1) {
            return commonParams + 2;
        }
        return (float)commonParams / (float)maxParams;
    }

    private static int longestCommonSubsequenceLength(List<?> as, List<?> bs, BiFunction<Integer, Integer, Integer> matchScoreFunction) {
        int[][] lengths = new int[as.size() + 1][bs.size() + 1];
        int maxLen = 0;
        for (int i = 0; i < as.size(); ++i) {
            for (int j = 0; j < bs.size(); ++j) {
                int matchScore = matchScoreFunction.apply(i, j);
                if (matchScore > 0) {
                    int n = lengths[i][j] + matchScore;
                    lengths[i + 1][j + 1] = n;
                    maxLen = n;
                    continue;
                }
                lengths[i + 1][j + 1] = Math.max(lengths[i + 1][j], lengths[i][j + 1]);
            }
        }
        return maxLen;
    }

    private static void addAllMethods(Collection<? extends Element> els, TreeMap<String, List<MethodElement>> methods) {
        els.forEach(e -> {
            if (e instanceof MethodElement) {
                JavaApiAnalyzer.add((MethodElement)e, methods);
            }
        });
    }

    private static void add(MethodElement method, TreeMap<String, List<MethodElement>> methods) {
        String name = ((ExecutableElement)method.getModelElement()).getSimpleName().toString();
        List<MethodElement> overloads = methods.get(name);
        if (overloads == null) {
            overloads = new ArrayList<MethodElement>();
            methods.put(name, overloads);
        }
        overloads.add(method);
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        ArrayList<String> checkConfigPaths = new ArrayList<String>();
        checkConfigPaths.add("revapi.java");
        for (Check c : this.checks) {
            String[] cp = c.getConfigurationRootPaths();
            if (cp == null) continue;
            checkConfigPaths.addAll(Arrays.asList(cp));
        }
        String[] configs = new String[checkConfigPaths.size()];
        configs = checkConfigPaths.toArray(configs);
        return configs;
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if ("revapi.java".equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/config-schema.json"), Charset.forName("UTF-8"));
        }
        for (Check check : this.checks) {
            String[] roots = check.getConfigurationRootPaths();
            if (roots == null) continue;
            for (String root : check.getConfigurationRootPaths()) {
                if (!configurationRootPath.equals(root)) continue;
                return check.getJSONSchema(root);
            }
        }
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
        this.configuration = AnalysisConfiguration.fromModel(analysisContext.getConfiguration());
    }

    @Nonnull
    public ArchiveAnalyzer getArchiveAnalyzer(@Nonnull API api) {
        Set<File> bootstrapClasspath = api == this.analysisContext.getOldApi() ? this.configuration.getOldApiBootstrapClasspath() : this.configuration.getNewApiBootstrapClasspath();
        boolean ignoreMissingAnnotations = this.configuration.isIgnoreMissingAnnotations();
        boolean skipUseTracking = !this.configuration.isDeepUseChainAnalysis();
        return new JavaArchiveAnalyzer(api, this.compilationExecutor, this.configuration.getMissingClassReporting(), ignoreMissingAnnotations, skipUseTracking, bootstrapClasspath);
    }

    @Nonnull
    public DifferenceAnalyzer getDifferenceAnalyzer(@Nonnull ArchiveAnalyzer oldArchive, @Nonnull ArchiveAnalyzer newArchive) {
        JavaArchiveAnalyzer oldA = (JavaArchiveAnalyzer)oldArchive;
        JavaArchiveAnalyzer newA = (JavaArchiveAnalyzer)newArchive;
        ProbingEnvironment oldEnvironment = oldA.getProbingEnvironment();
        ProbingEnvironment newEnvironment = newA.getProbingEnvironment();
        CompilationValve oldValve = oldA.getCompilationValve();
        CompilationValve newValve = newA.getCompilationValve();
        return new JavaElementDifferenceAnalyzer(this.analysisContext, oldEnvironment, oldValve, newEnvironment, newValve, this.checks, this.configuration);
    }

    public void close() {
        this.compilationExecutor.shutdown();
    }
}

