/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class JavaFilesCache
extends BaseTreeVisitor
implements JavaFileScanner {
    @VisibleForTesting
    Map<String, File> resourcesCache = Maps.newHashMap();
    private File currentFile;
    private Deque<String> currentClassKey = new LinkedList<String>();
    private Deque<Tree> parent = new LinkedList<Tree>();
    private Deque<Integer> anonymousInnerClassCounter = new LinkedList<Integer>();
    private String currentPackage;

    public Map<String, File> getResourcesCache() {
        return this.resourcesCache;
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        JavaTree.CompilationUnitTreeImpl tree = (JavaTree.CompilationUnitTreeImpl)context.getTree();
        this.currentPackage = JavaTree.PackageDeclarationTreeImpl.packageNameAsString(tree.packageDeclaration()).replace('.', '/');
        this.currentFile = context.getFile();
        this.currentClassKey.clear();
        this.parent.clear();
        this.anonymousInnerClassCounter.clear();
        this.scan(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        String className = "";
        IdentifierTree simpleName = tree.simpleName();
        if (simpleName != null) {
            className = simpleName.name();
        }
        String key = this.getClassKey(className);
        this.currentClassKey.push(key);
        this.parent.push(tree);
        this.anonymousInnerClassCounter.push(0);
        this.resourcesCache.put(key, this.currentFile);
        super.visitClass(tree);
        this.currentClassKey.pop();
        this.parent.pop();
        this.anonymousInnerClassCounter.pop();
    }

    private String getClassKey(String className) {
        String key = className;
        if (StringUtils.isNotEmpty((String)this.currentPackage)) {
            key = this.currentPackage + "/" + className;
        }
        if ("".equals(className) || this.parent.peek() != null && this.parent.peek().is(Tree.Kind.METHOD)) {
            int count = this.anonymousInnerClassCounter.pop() + 1;
            key = this.currentClassKey.peek() + "$" + count + className;
            this.anonymousInnerClassCounter.push(count);
        } else if (this.currentClassKey.peek() != null) {
            key = this.currentClassKey.peek() + "$" + className;
        }
        return key;
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.parent.push(tree);
        super.visitMethod(tree);
        this.parent.pop();
    }
}

