/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1717", priority=Priority.MAJOR, name="\"\\\" should only be used as an escape character outside of raw strings")
@SqaleConstantRemediation(value="2min")
public class BackslashInStringCheck
extends PythonCheck {
    private static final String MESSAGE = "Remove this \"\\\", add another \"\\\" to escape it, or make this a raw string.";
    private static final String VALID_ESCAPED_CHARACTERS = "abfnrtvxnNrtuU\\'\"0123456789\n\r";
    public static final String CHECK_KEY = "S1717";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.STRING});
    }

    public void visitNode(AstNode node) {
        String string = node.getTokenOriginalValue();
        int length = string.length();
        boolean isEscaped = false;
        boolean inPrefix = true;
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if ((inPrefix = BackslashInStringCheck.isInPrefix(inPrefix, c)) && (c == 'r' || c == 'R')) {
                return;
            }
            if (inPrefix) continue;
            if (isEscaped && VALID_ESCAPED_CHARACTERS.indexOf(c) == -1) {
                this.addIssue(node, MESSAGE);
            }
            isEscaped = c == '\\' && !isEscaped;
        }
    }

    private static boolean isInPrefix(boolean wasInPrefix, char currentChar) {
        return wasInPrefix && currentChar != '\"' && currentChar != '\'';
    }
}

