/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.checks.NewSymbolsAnalyzer;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S117", priority=Priority.MINOR, name="Local variable and function parameter names should comply with a naming convention", tags={"convention"})
@SqaleConstantRemediation(value="2min")
@ActivatedByDefault
public class LocalVariableAndParameterNameConventionCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S117";
    public static final String MESSAGE = "Rename this %s \"%s\" to match the regular expression %s.";
    public static final String PARAMETER = "parameter";
    public static final String LOCAL_VAR = "local variable";
    private static final String CONSTANT_PATTERN = "^[_A-Z][A-Z0-9_]*$";
    private static final String DEFAULT = "^[_a-z][a-z0-9_]*$";
    @RuleProperty(key="format", defaultValue="^[_a-z][a-z0-9_]*$")
    public String format = "^[_a-z][a-z0-9_]*$";
    private Pattern pattern = null;
    private Pattern constantPattern = null;

    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.constantPattern = Pattern.compile(CONSTANT_PATTERN);
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode astNode) {
        List<Token> parameters = this.visitParameters(astNode);
        this.visitLocalVariables(astNode, parameters);
    }

    private void visitLocalVariables(AstNode funcDef, List<Token> parameters) {
        AstNode suite = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        if (suite != null) {
            List expressions = suite.getDescendants(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT});
            List<Token> varNames = new LinkedList<Token>();
            List<Token> forCounterNames = LocalVariableAndParameterNameConventionCheck.getForCounterNames(suite);
            for (AstNode expression : expressions) {
                if (!CheckUtils.isAssignmentExpression(expression) || !CheckUtils.insideFunction(expression, funcDef)) continue;
                varNames = new NewSymbolsAnalyzer().getVariablesFromLongAssignmentExpression(varNames, expression);
            }
            for (int i = 0; i < varNames.size(); ++i) {
                if (!CheckUtils.containsValue(parameters, ((Token)varNames.get(i)).getValue()) && !CheckUtils.containsValue(forCounterNames, ((Token)varNames.get(i)).getValue())) continue;
                varNames.remove(i);
            }
            this.checkNames(varNames, forCounterNames);
        }
    }

    private void checkNames(List<Token> varNames, List<Token> forCounterNames) {
        for (Token name : varNames) {
            if (this.constantPattern.matcher(name.getValue()).matches()) continue;
            this.checkName(name, LOCAL_VAR);
        }
        for (Token name : forCounterNames) {
            if (name.getValue().length() <= 1) continue;
            this.checkName(name, LOCAL_VAR);
        }
    }

    private static List<Token> getForCounterNames(AstNode suite) {
        List forStatements = suite.getDescendants(new AstNodeType[]{PythonGrammar.FOR_STMT});
        LinkedList<Token> result = new LinkedList<Token>();
        for (AstNode forStatement : forStatements) {
            AstNode counters = forStatement.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST});
            for (AstNode name : counters.getDescendants(new AstNodeType[]{PythonGrammar.NAME})) {
                Token token = name.getToken();
                if (!token.getType().equals(GenericTokenType.IDENTIFIER)) continue;
                result.add(token);
            }
        }
        return result;
    }

    private List<Token> visitParameters(AstNode astNode) {
        LinkedList<Token> parameterTokens = new LinkedList<Token>();
        AstNode varArgList = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (varArgList != null) {
            List funcParameters = varArgList.getDescendants(new AstNodeType[]{PythonGrammar.TFPDEF});
            funcParameters.addAll(varArgList.getChildren(new AstNodeType[]{PythonGrammar.NAME}));
            for (AstNode parameter : funcParameters) {
                Token token = parameter.getToken();
                if (!token.getType().equals(GenericTokenType.IDENTIFIER)) continue;
                parameterTokens.add(token);
                this.checkName(token, PARAMETER);
            }
        }
        return parameterTokens;
    }

    private void checkName(Token token, String type) {
        String name = token.getValue();
        if (!this.pattern.matcher(name).matches()) {
            this.addIssue(token, String.format(MESSAGE, type, name, this.format));
        }
    }
}

