/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource.v2;

import java.util.Base64;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.testobject.rest.api.model.DynamicInstrumentationRequestData;
import org.testobject.rest.api.model.InstrumentationReport;
import org.testobject.rest.api.model.StartInstrumentationResponse;
import org.testobject.rest.api.model.StaticInstrumentationRequestData;
import org.testobject.rest.api.resource.v2.InstrumentationResource;

public class InstrumentationResourceImpl
implements InstrumentationResource {
    private final WebTarget target;

    public InstrumentationResourceImpl(WebTarget target) {
        this.target = target;
    }

    @Override
    public StartInstrumentationResponse createAndStartXCUITestInstrumentation(String apiKey, StaticInstrumentationRequestData requestData) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(apiKey);
        return this.target.path("v2").path("instrumentation").path("xcuitest").request("application/json").header("Authorization", authorizationHeaderValue).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    @Override
    public StartInstrumentationResponse createAndStartXCUITestInstrumentation(String apiKey, DynamicInstrumentationRequestData requestData) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(apiKey);
        return this.target.path("v2").path("instrumentation").path("xcuitest").path("dynamic").request("application/json").header("Authorization", authorizationHeaderValue).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    @Override
    public StartInstrumentationResponse createAndStartAndroidInstrumentation(String apiKey, StaticInstrumentationRequestData requestData) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(apiKey);
        return this.target.path("v2").path("instrumentation").path("android").request("application/json").header("Authorization", authorizationHeaderValue).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    @Override
    public StartInstrumentationResponse createAndStartAndroidInstrumentation(String apiKey, DynamicInstrumentationRequestData requestData) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(apiKey);
        return this.target.path("v2").path("instrumentation").path("android").path("dynamic").request("application/json").header("Authorization", authorizationHeaderValue).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    @Override
    public String getJUnitReport(String apiKey, long reportId) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(apiKey);
        return this.target.path("v2").path("instrumentation").path("testreport").path(Long.toString(reportId)).path("junitreport").request("application/xml").header("Authorization", authorizationHeaderValue).get(String.class);
    }

    @Override
    public InstrumentationReport getTestReport(String apiKey, long reportId) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(apiKey);
        return this.target.path("v2").path("instrumentation").path("testreport").path(Long.toString(reportId)).request("application/json").header("Authorization", authorizationHeaderValue).get(InstrumentationReport.class);
    }

    private String getAuthorizationHeaderValue(String apiKey) {
        return "Basic " + Base64.getEncoder().encodeToString(("user:" + apiKey).getBytes());
    }
}

