/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.api;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import org.testobject.api.TestObjectRemoteClient;
import org.testobject.rest.api.model.AppiumTestReport;
import org.testobject.rest.api.model.DeviceDescriptor;
import org.testobject.rest.api.model.PaginationObject;
import org.testobject.rest.api.model.SessionReport;
import org.testobject.rest.api.model.TestSuiteReport;
import org.testobject.rest.api.resource.TestSuiteResource;

public interface TestObjectClient
extends Closeable {
    public void updateInstrumentationTestSuite(String var1, String var2, long var3, File var5, File var6, TestSuiteResource.InstrumentationTestSuiteRequest var7);

    public long startInstrumentationTestSuite(String var1, String var2, long var3);

    public Long createInstrumentationTestSuite(String var1, String var2, long var3, File var5, File var6, TestSuiteResource.InstrumentationTestSuiteRequest var7);

    public TestSuiteReport waitForSuiteReport(String var1, String var2, long var3);

    public TestSuiteReport waitForSuiteReport(String var1, String var2, long var3, long var5, long var7);

    public void createAppVersion(String var1, String var2, File var3);

    public long startQualityReport(String var1, String var2);

    public PaginationObject<SessionReport> getSessionReport(String var1);

    public PaginationObject<SessionReport> getSessionReport(String var1, String var2, long var3, int var5, int var6);

    public List<DeviceDescriptor> listDevices();

    public AppiumTestReport getTestReport(String var1, String var2, long var3);

    public File saveVideo(String var1, String var2, String var3, File var4);

    @Override
    public void close();

    public static final class Factory {
        private static final String BASE_URL = "https://appium.testobject.com/api/rest";

        public static TestObjectClient create() {
            return Factory.create(BASE_URL, null);
        }

        public static TestObjectClient create(String baseUrl) {
            return Factory.create(baseUrl, null);
        }

        public static TestObjectClient create(String baseUrl, ProxySettings proxySettings) {
            return new TestObjectRemoteClient(baseUrl, proxySettings);
        }
    }

    public static final class ProxySettings {
        private final String host;
        private final int port;
        private final String username;
        private final String password;

        public ProxySettings(String host, int port, String username, String password) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

