/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource.v2;

import java.util.Base64;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.testobject.rest.api.model.InstrumentationRequestData;
import org.testobject.rest.api.model.XcuiTestReport;
import org.testobject.rest.api.resource.v2.InstrumentationResource;

public class InstrumentationResourceImpl
implements InstrumentationResource {
    private final WebTarget target;

    public InstrumentationResourceImpl(WebTarget target) {
        this.target = target;
    }

    @Override
    public long createAndStartXCUITestInstrumentation(String apiKey, InstrumentationRequestData requestData) {
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(("user:" + apiKey).getBytes());
        return this.target.path("v2").path("instrumentation").path("xcuitest").request("application/json").header("Authorization", authorizationHeaderValue).post(Entity.json(requestData), Long.class);
    }

    @Override
    public String getJUnitReport(String apiKey, long reportId) {
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(("user:" + apiKey).getBytes());
        return this.target.path("v2").path("instrumentation").path("testreport").path(Long.toString(reportId)).path("junitreport").request("application/xml").header("Authorization", authorizationHeaderValue).get(String.class);
    }

    @Override
    public XcuiTestReport getTestReport(String apiKey, long reportId) {
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(("user:" + apiKey).getBytes());
        return this.target.path("v2").path("instrumentation").path("testreport").path(Long.toString(reportId)).request("application/json").header("Authorization", authorizationHeaderValue).get(XcuiTestReport.class);
    }
}

