/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.reporter.inspect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.utplsql.api.Version;
import org.utplsql.api.compatibility.CompatibilityProxy;
import org.utplsql.api.exception.InvalidVersionException;
import org.utplsql.api.reporter.ReporterFactory;
import org.utplsql.api.reporter.inspect.ReporterInfo;
import org.utplsql.api.reporter.inspect.ReporterInspector310;
import org.utplsql.api.reporter.inspect.ReporterInspectorPre310;

public interface ReporterInspector {
    public static ReporterInspector create(ReporterFactory reporterFactory, Connection conn) throws SQLException, InvalidVersionException {
        CompatibilityProxy proxy = new CompatibilityProxy(conn);
        if (proxy.getUtPlsqlVersion().isGreaterOrEqualThan(Version.V3_1_0)) {
            return new ReporterInspector310(reporterFactory, conn);
        }
        return new ReporterInspectorPre310(reporterFactory, conn);
    }

    public List<ReporterInfo> getReporterInfos();

    default public Map<String, ReporterInfo> getReporterInfoMap() {
        return this.getReporterInfos().stream().collect(Collectors.toMap(ReporterInfo::getName, Function.identity()));
    }
}

