/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.CookieManager;
import org.jdesktop.http.DefaultSecurityHandler;
import org.jdesktop.http.Header;
import org.jdesktop.http.HighSecurityX509TrustManager;
import org.jdesktop.http.LowSecurityX509TrustManager;
import org.jdesktop.http.MediumSecurityX509TrustManager;
import org.jdesktop.http.Method;
import org.jdesktop.http.NameValuePair;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Request;
import org.jdesktop.http.Response;
import org.jdesktop.http.SecurityHandler;
import org.jdesktop.http.State;
import org.jdesktop.http.StatusCode;

public class Session
extends AbstractBean {
    private SecurityLevel sslSecurity;
    private SecurityHandler handler;
    private State state = State.READY;
    private long totalBytes = -1L;
    private long bytesSoFar = 0L;

    public Session() {
        this(true);
    }

    public Session(boolean bl) {
        this.setSslSecurityLevel(SecurityLevel.Medium);
        this.setMediumSecurityHandler(new DefaultSecurityHandler());
        if (bl) {
            CookieManager.install();
        }
    }

    public void setSslSecurityLevel(SecurityLevel securityLevel) {
        SecurityLevel securityLevel2 = this.getSslSecurityLevel();
        this.sslSecurity = securityLevel;
        this.firePropertyChange("sslSecurityLevel", (Object)securityLevel2, (Object)this.getSslSecurityLevel());
    }

    public final SecurityLevel getSslSecurityLevel() {
        return this.sslSecurity;
    }

    void setMediumSecurityHandler(SecurityHandler securityHandler) {
        SecurityHandler securityHandler2 = this.getMediumSecurityHandler();
        this.handler = securityHandler;
        this.firePropertyChange("mediumSecurityHandler", securityHandler2, this.getMediumSecurityHandler());
    }

    SecurityHandler getMediumSecurityHandler() {
        return this.handler;
    }

    private SSLSocketFactory createSocketFactory(String string) {
        try {
            X509TrustManager x509TrustManager = null;
            SecurityLevel securityLevel = this.getSslSecurityLevel();
            x509TrustManager = securityLevel == SecurityLevel.Low ? new LowSecurityX509TrustManager(null) : (securityLevel == SecurityLevel.Medium ? new MediumSecurityX509TrustManager(string, this.getMediumSecurityHandler(), null) : new HighSecurityX509TrustManager(null));
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    private void setTotalBytes(long l) {
        long l2 = this.totalBytes;
        float f = this.getProgress();
        this.totalBytes = l;
        this.firePropertyChange("totalBytes", l2, this.totalBytes);
        this.firePropertyChange("progress", Float.valueOf(f), Float.valueOf(this.getProgress()));
    }

    public final long getBytesSoFar() {
        return this.bytesSoFar;
    }

    private void setBytesSoFar(long l) {
        long l2 = this.bytesSoFar;
        float f = this.getProgress();
        this.bytesSoFar = l;
        this.firePropertyChange("bytesSoFar", l2, this.bytesSoFar);
        this.firePropertyChange("progress", Float.valueOf(f), Float.valueOf(this.getProgress()));
    }

    public final float getProgress() {
        if (this.totalBytes <= 0L) {
            return -1.0f;
        }
        float f = this.totalBytes;
        float f2 = this.bytesSoFar;
        return f2 / f;
    }

    public final State getState() {
        return this.state;
    }

    protected void setState(State state) {
        State state2 = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)state2, (Object)this.state);
    }

    public final Response get(String string) throws Exception {
        return this.execute(Method.GET, string);
    }

    public final Response get(String string, Parameter ... parameterArray) throws Exception {
        return this.execute(Method.GET, string, parameterArray);
    }

    public final Response post(String string) throws Exception {
        return this.execute(Method.POST, string);
    }

    public final Response post(String string, Parameter ... parameterArray) throws Exception {
        return this.execute(Method.POST, string, parameterArray);
    }

    public final Response put(String string) throws Exception {
        return this.execute(Method.PUT, string);
    }

    public final Response put(String string, Parameter ... parameterArray) throws Exception {
        return this.execute(Method.PUT, string, parameterArray);
    }

    public final Response execute(Method method, String string) throws Exception {
        return this.execute(method, string, new Parameter[0]);
    }

    public final Response execute(Method method, String string, Parameter ... parameterArray) throws Exception {
        if (method == null) {
            throw new NullPointerException("method cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("url cannot be null");
        }
        Request request = new Request();
        request.setParameters(parameterArray);
        request.setMethod(method);
        request.setUrl(string);
        return this.execute(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(Request request) throws Exception {
        try {
            Object object;
            int n;
            Object object2;
            Object object3;
            String string;
            Object object4;
            Object object52;
            Object object6;
            this.setTotalBytes(-1L);
            this.setBytesSoFar(0L);
            this.setState(State.CONNECTING);
            StringBuffer stringBuffer = new StringBuffer(request.getUrl());
            if (stringBuffer.length() == 0) {
                this.setState(State.FAILED);
                throw new IllegalStateException("Cannot excecute a request that has no URL specified");
            }
            int n2 = 63;
            for (Parameter parameter : request.getParameters()) {
                stringBuffer.append((char)n2);
                n2 = 38;
                String string2 = URLEncoder.encode(parameter.getName(), "UTF-8");
                String string3 = URLEncoder.encode(parameter.getValue(), "UTF-8");
                stringBuffer.append(string2 + "=" + string3);
            }
            URL uRL = this.createURL(stringBuffer.toString());
            URLConnection uRLConnection = uRL.openConnection();
            if (!(uRLConnection instanceof HttpURLConnection)) {
                this.setState(State.FAILED);
                throw new IllegalStateException("Must be an HTTP or HTTPS based URL");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod(request.getMethod().name());
            httpURLConnection.setInstanceFollowRedirects(request.getFollowRedirects());
            for (Header header : request.getHeaders()) {
                httpURLConnection.setRequestProperty(header.getName(), header.getValue());
            }
            if (httpURLConnection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                httpsURLConnection.setSSLSocketFactory(this.createSocketFactory(uRL.getHost()));
            }
            long l = -1L;
            Header header = request.getHeader("Content-Length");
            if (header != null) {
                try {
                    l = Long.parseLong(header.getValue().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
            }
            this.setTotalBytes(l);
            this.setState(State.SENDING);
            OutputStream outputStream = null;
            InputStream inputStream = request.getBody();
            if (inputStream != null) {
                block35: {
                    OutputStream outputStream2;
                    try {
                        httpURLConnection.setDoOutput(true);
                        outputStream2 = httpURLConnection.getOutputStream();
                        object6 = new byte[8096];
                        int n3 = -1;
                        while ((n3 = inputStream.read((byte[])object6)) != -1) {
                            outputStream2.write((byte[])object6, 0, n3);
                            this.setBytesSoFar(this.bytesSoFar + (long)n3);
                        }
                        if (outputStream2 == null) break block35;
                    }
                    catch (Exception exception) {
                        try {
                            this.setState(State.FAILED);
                            throw exception;
                        }
                        catch (Throwable throwable) {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            inputStream.close();
                            throw throwable;
                        }
                    }
                    outputStream2.close();
                }
                inputStream.close();
            }
            this.setState(State.SENT);
            httpURLConnection.connect();
            this.setBytesSoFar(0L);
            this.setTotalBytes(httpURLConnection.getContentLength());
            this.setState(State.RECEIVING);
            object6 = new HashSet();
            Object object7 = null;
            for (Object object52 : httpURLConnection.getHeaderFields().entrySet()) {
                object4 = (String)object52.getKey();
                string = httpURLConnection.getHeaderField((String)object4);
                if (object4 == null) continue;
                object3 = (List)object52.getValue();
                Header.Element[] elementArray = new Header.Element[object3.size()];
                for (int i = 0; i < elementArray.length; ++i) {
                    elementArray[i] = new Header.Element(new Parameter((String)object3.get(i), (String)object3.get(i)));
                }
                object2 = new Header((String)object4, string, elementArray);
                object6.add(object2);
                if (!"Content-Type".equalsIgnoreCase((String)object4)) continue;
                object7 = object2;
            }
            Object object8 = null;
            object52 = StatusCode.INTERNAL_SERVER_ERROR;
            object4 = null;
            try {
                object4 = httpURLConnection.getInputStream();
                object52 = StatusCode.valueOf(httpURLConnection.getResponseCode());
                string = httpURLConnection.getContentEncoding();
                if ("gzip".equals(string)) {
                    object4 = new GZIPInputStream((InputStream)object4);
                }
                object8 = this.readFully((InputStream)object4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                object4 = httpURLConnection.getErrorStream();
                object8 = this.readFully((InputStream)object4);
            }
            catch (HttpRetryException httpRetryException) {
                this.setState(State.FAILED);
                object3 = new Response(StatusCode.NOT_FOUND, "HttpRetryException: " + httpRetryException.getMessage(), null, null, null, request.getUrl());
                return object3;
            }
            catch (UnknownHostException unknownHostException) {
                this.setState(State.FAILED);
                object3 = new Response(StatusCode.NOT_FOUND, "Unknown host", null, null, null, request.getUrl());
                return object3;
            }
            catch (IOException iOException) {
                object3 = iOException.getMessage();
                if (object3 == null) throw iOException;
                if (!((String)object3).contains("Server returned HTTP response code:")) throw iOException;
                int n4 = ((String)object3).indexOf("code: ") + 6;
                object2 = ((String)object3).substring(n4, n4 + 3);
                object52 = StatusCode.valueOf(Integer.parseInt((String)object2));
                object4 = httpURLConnection.getErrorStream();
                object8 = this.readFully((InputStream)object4);
            }
            finally {
                if (object4 != null) {
                    ((InputStream)object4).close();
                }
            }
            string = "foo";
            object3 = new URI(request.getUrl());
            URI uRI = ((URI)object3).resolve(new URI(string));
            object2 = uRI.toString().substring(0, uRI.toString().length() - string.length());
            String string4 = null;
            if (object7 != null && (n = ((String)(object = ((NameValuePair)object7).getValue())).indexOf(";")) >= 0 && (n = ((String)object).indexOf("=", n + 1)) > 0) {
                string4 = ((NameValuePair)object7).getValue().substring(n + 1);
            }
            object = new Response((StatusCode)((Object)object52), httpURLConnection.getResponseMessage(), (byte[])object8, string4, (Set<Header>)object6, (String)object2);
            this.setState(State.DONE);
            return object;
        }
        catch (InterruptedException interruptedException) {
            this.setState(State.ABORTED);
            throw interruptedException;
        }
    }

    protected URL createURL(String string) throws MalformedURLException {
        return new URL(string.toString());
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8096);
        byte[] byArray = new byte[8096];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            this.setBytesSoFar(this.bytesSoFar + (long)n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static enum SecurityLevel {
        Low,
        Medium,
        High;

    }
}

