/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.serialize;

import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class JsonSerializer {
    public static <T> String marshal(T object) throws Exception {
        return JsonSerializer.marshal(object, "");
    }

    public static <T> String marshal(T object, String rootName) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String result = mapper.writeValueAsString(object);
        if (rootName != null && !"".equals(rootName)) {
            result = "{\"" + rootName + "\": " + result + "}";
        }
        return result;
    }

    public static <T> T unmarshal(String data, Class<T> objectClass) throws Exception {
        return JsonSerializer.unmarshal(data, "", objectClass);
    }

    public static <T> T unmarshal(String data, String rootName, Class<T> objectClass) throws Exception {
        if (rootName != null && !"".equals(rootName)) {
            data = "{\"" + rootName + "\": " + data + "}";
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector);
        return (T)mapper.readValue(data, objectClass);
    }
}

