/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.string;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class StringUtils {
    public static String emptyIfNull(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public static String listAsString(List<String> stringList) {
        String result = "";
        for (String oneString : stringList) {
            result = result + oneString + ",";
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String getMd5String(String input) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(input.getBytes(Charset.forName("UTF8")));
        byte[] resultByte = messageDigest.digest();
        String result = Hex.encodeHexString((byte[])resultByte);
        return result;
    }

    public static boolean isStringInList(List<String> stringList, String toSearch) {
        toSearch = StringUtils.emptyIfNull(toSearch);
        for (String entry : stringList) {
            if (entry == null || !toSearch.equals(entry)) continue;
            return true;
        }
        return false;
    }

    public static List<String> addUniqueString(String toAdd, List<String> strings) {
        if (!StringUtils.isStringInList(strings, toAdd = StringUtils.emptyIfNull(toAdd))) {
            strings.add(toAdd);
        }
        return strings;
    }

    public static boolean containsAll(String source, String ... toSearch) {
        if (source == null || toSearch == null || toSearch.length == 0) {
            return false;
        }
        for (String entry : toSearch) {
            if (source.contains(entry)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String source, String ... toSearch) {
        if (source == null || toSearch == null || toSearch.length == 0) {
            return false;
        }
        for (String entry : toSearch) {
            if (!source.contains(entry)) continue;
            return true;
        }
        return false;
    }
}

