/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.greatbit.utils.collection.Difference;
import ru.greatbit.utils.collection.Wrapper;
import ru.greatbit.utils.serialize.JsonSerializer;
import ru.greatbit.utils.string.StringUtils;

public class CollectionUtils {
    public static <T> List<T> mergeLists(List<T> first, List<T> second) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(first);
        set.addAll(second);
        first.clear();
        first.addAll(set);
        return first;
    }

    public static <T> List<T> mergeListsByValue(List<T> first, List<T> second) throws Exception {
        Map<String, T> dataMap = CollectionUtils.listToMD5Map(first);
        for (T object : second) {
            dataMap.put(StringUtils.getMd5String(JsonSerializer.marshal(object)), object);
        }
        return dataMap.values().stream().collect(Collectors.toList());
    }

    public static <T> Difference getDiff(List<T> first, List<T> second) {
        return CollectionUtils.getDiff(CollectionUtils.listToMap(first), CollectionUtils.listToMap(second));
    }

    public static <T> Difference getDiffAnyObject(List<T> first, List<T> second) throws Exception {
        return CollectionUtils.getDiff(CollectionUtils.listToMD5Map(first), CollectionUtils.listToMD5Map(second));
    }

    private static <K, V> Difference getDiff(Map<K, V> firstMap, Map<K, V> secondMap) {
        Difference difference = new Difference();
        secondMap.entrySet().forEach(entry -> {
            Object value = firstMap.get(entry.getKey());
            if (value == null) {
                difference.getAdded().add(entry.getValue());
            } else {
                difference.getEqual().add(value);
            }
        });
        firstMap.entrySet().forEach(entry -> {
            Object value = secondMap.get(entry.getKey());
            if (value == null) {
                difference.getRemoved().add(entry.getValue());
            }
        });
        return difference;
    }

    public static <V> Map<V, V> listToMap(List<V> input) {
        LinkedHashMap dataMap = new LinkedHashMap();
        input.forEach(value -> dataMap.put(value, value));
        return dataMap;
    }

    public static <T> Map<String, T> listToMD5Map(List<T> input) throws Exception {
        LinkedHashMap<String, T> dataMap = new LinkedHashMap<String, T>();
        for (T object : input) {
            dataMap.put(StringUtils.getMd5String(JsonSerializer.marshal(object)), object);
        }
        return dataMap;
    }

    public static <T> List<T> removeByIndex(List<T> input, int index) {
        LinkedList<T> result = new LinkedList<T>(input);
        result.remove(index);
        if (input.getClass().getName().equals("java.util.Arrays$ArrayList")) {
            input = Arrays.asList(result.toArray());
        } else {
            input.clear();
            input.addAll(result);
        }
        return input;
    }

    public static <T, K> Map<K, List<T>> removeDuplicateValues(Map<K, List<T>> values) {
        if (values == null) {
            return values;
        }
        values.entrySet().forEach(entry -> entry.setValue(((List)entry.getValue()).stream().distinct().collect(Collectors.toList())));
        return values;
    }

    public static <T> List<T> removeDuplicateValues(List<T> values) {
        if (values == null) {
            return values;
        }
        return values.stream().distinct().collect(Collectors.toList());
    }

    public static <T> List<T> removeDuplicateValues(List<T> values, Function<T, Object> meaningValue) {
        if (values == null) {
            return values;
        }
        return values.stream().map(value -> new Wrapper<Object>(value, meaningValue)).distinct().map(wrapper -> wrapper.getObject()).collect(Collectors.toList());
    }

    public static <T extends Comparable> List<T> reorder(List<T> elements, List<T> order) {
        if (order.size() == 0) {
            return elements;
        }
        if (elements.size() == 0) {
            return order;
        }
        HashMap<T, Integer> elementsIndexMap = new HashMap<T, Integer>();
        for (int i = 0; i < elements.size(); ++i) {
            elementsIndexMap.put(elements.get(i), i);
        }
        LinkedHashSet<Object> merged = new LinkedHashSet<Object>();
        HashSet<T> elementsSet = new HashSet<T>(elements);
        int i = 0;
        int j = 0;
        Comparable currElement = (Comparable)elements.get(i);
        Comparable currOrder = (Comparable)order.get(j);
        while (i < elements.size() || j < order.size()) {
            if (j >= order.size()) {
                merged.addAll(elements.subList(i, elements.size()));
                break;
            }
            currElement = i < elements.size() ? (Comparable)elements.get(i) : currElement;
            currOrder = j < order.size() ? (Comparable)order.get(j) : currOrder;
            Integer currElementIndex = (Integer)elementsIndexMap.get(currElement);
            Integer currOrderIndexInElements = (Integer)elementsIndexMap.get(currOrder);
            if (currElementIndex.compareTo(currOrderIndexInElements = Integer.valueOf(currOrderIndexInElements == null ? elements.size() : currOrderIndexInElements.intValue())) < 0) {
                merged.add(currElement);
                ++i;
            }
            if (currOrderIndexInElements.compareTo(currElementIndex) < 0 || i >= elements.size()) {
                if (merged.contains(currOrder)) {
                    merged.remove(currOrder);
                }
                if (elementsSet.contains(currOrder)) {
                    merged.add(currOrder);
                }
                ++j;
            }
            if (currElementIndex.compareTo(currOrderIndexInElements) != 0) continue;
            merged.add(currElement);
            ++i;
            ++j;
        }
        return new ArrayList(merged);
    }

    public static <T extends Comparable> void swap(List<T> elements, int i, int j) {
        Comparable buff = (Comparable)elements.get(j);
        elements.set(j, elements.get(i));
        elements.set(i, buff);
    }
}

