/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.math;

import java.util.LinkedList;
import java.util.List;
import ru.greatbit.utils.exceptions.MathException;

public class Sequence {
    public static long factorial(int depth) throws MathException {
        if (depth <= 0) {
            throw new MathException("Factorial is not supported for values less or equal to 0");
        }
        if (depth == 1) {
            return 1L;
        }
        return Sequence.factorial(depth - 1) * (long)depth;
    }

    public static List<Long> factorialSequence(int depth) throws MathException {
        LinkedList<Long> result = new LinkedList<Long>();
        if (depth <= 0) {
            throw new MathException("Factorial is not supported for values less or equal to 0");
        }
        Sequence.factorialSequence(depth, result);
        return result;
    }

    private static void factorialSequence(int depth, List<Long> values) {
        if (depth == 1) {
            values.add(1L);
            return;
        }
        Sequence.factorialSequence(depth - 1, values);
        values.add(values.get(values.size() - 1) * (long)depth);
    }

    public static long fibonacci(int depth) throws MathException {
        if (depth <= 0) {
            throw new MathException("Fibonacci is not supported for values less or equal to 0");
        }
        if (depth == 1 || depth == 2) {
            return 1L;
        }
        return Sequence.fibonacci(depth - 1) + Sequence.fibonacci(depth - 2);
    }

    public static List<Long> fibonacciSequence(int depth) throws MathException {
        LinkedList<Long> result = new LinkedList<Long>();
        if (depth <= 0) {
            throw new MathException("Factorial is not supported for values less or equal to 0");
        }
        Sequence.fibonacciSequence(depth, result);
        return result;
    }

    private static void fibonacciSequence(int depth, List<Long> result) {
        if (depth == 1) {
            result.add(1L);
            return;
        }
        if (depth == 2) {
            result.add(1L);
            result.add(1L);
            return;
        }
        Sequence.fibonacciSequence(depth - 1, result);
        result.add(result.get(result.size() - 1) + result.get(result.size() - 2));
    }
}

