/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.serialize;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;

public class JsonSerializer {
    public static <T> String marshal(T object) throws Exception {
        return JsonSerializer.marshal(object, "");
    }

    public static <T> String marshal(T object, String rootName) throws Exception {
        String result = JsonSerializer.createObjectMapper().writeValueAsString(object);
        if (rootName != null && !"".equals(rootName)) {
            result = "{\"" + rootName + "\": " + result + "}";
        }
        return result;
    }

    public static <T> T unmarshal(String data, Class<T> objectClass) throws Exception {
        return JsonSerializer.unmarshal(data, "", objectClass);
    }

    public static <T> T unmarshal(String data, String rootName, Class<T> objectClass) throws Exception {
        if (rootName != null && !"".equals(rootName)) {
            data = "{\"" + rootName + "\": " + data + "}";
        }
        return (T)JsonSerializer.createObjectMapper().readValue(data, objectClass);
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setAnnotationIntrospector(AnnotationIntrospector.pair((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()), (AnnotationIntrospector)new JacksonAnnotationIntrospector()));
        return mapper;
    }
}

