/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.tree.processors;

import java.util.LinkedList;
import java.util.List;
import ru.greatbit.utils.tree.nodes.Node;
import ru.greatbit.utils.tree.processors.api.Visitor;

public class Traverse {
    public static <K, V> List<Node<K, V>> bfsList(Node<K, V> head) {
        final LinkedList<Node<K, V>> result = new LinkedList<Node<K, V>>();
        Traverse.bfsVisit(head, new Visitor(){

            public void visit(Node node) {
                result.add(node);
            }
        });
        return result;
    }

    public static <K, V> void bfsVisit(Node<K, V> head, Visitor visitor) {
        if (head == null) {
            return;
        }
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(head);
        while (!queue.isEmpty()) {
            if (!queue.isEmpty()) {
                head = (Node)queue.poll();
                visitor.visit(head);
            }
            for (Node child : head.getChildren()) {
                queue.add(child);
            }
        }
    }

    public static <K, V> List<Node<K, V>> dfsList(Node<K, V> head) {
        LinkedList<Node<K, V>> result = new LinkedList<Node<K, V>>();
        Traverse.dfsList(head, result);
        return result;
    }

    private static <K, V> void dfsList(Node<K, V> head, final List<Node<K, V>> result) {
        Traverse.dfsVisit(head, new Visitor(){

            public void visit(Node node) {
                result.add(node);
            }
        });
    }

    public static <K, V> void dfsVisit(Node<K, V> head, Visitor visitor) {
        if (head == null) {
            return;
        }
        visitor.visit(head);
        for (Node children : head.getChildren()) {
            Traverse.dfsVisit(children, visitor);
        }
    }

    public static <K, V> List<Node<K, V>> getLeafs(Node<K, V> head) {
        LinkedList<Node<K, V>> result = new LinkedList<Node<K, V>>();
        Traverse.getLeafs(head, result);
        return result;
    }

    public static <K, V> void getLeafs(Node<K, V> head, List<Node<K, V>> result) {
        if (head == null) {
            return;
        }
        if (head.getChildren().size() == 0) {
            result.add(head);
        } else {
            for (Node node : head.getChildren()) {
                Traverse.getLeafs(node, result);
            }
        }
    }

    public static <K, V> long countLeafs(Node<K, V> head) {
        long count = 0L;
        if (head == null) {
            return count;
        }
        if (head.getChildren().size() == 0) {
            return 1L;
        }
        for (Node node : head.getChildren()) {
            count += Traverse.countLeafs(node);
        }
        return count;
    }

    public static <K, V> int countMaxHeight(Node<K, V> head) {
        if (head == null) {
            return 0;
        }
        LinkedList<Integer> heights = new LinkedList<Integer>();
        for (Node node : head.getChildren()) {
            heights.add(Traverse.countMaxHeight(node));
        }
        int max = 0;
        for (Integer childHeight : heights) {
            max = Math.max(max, childHeight);
        }
        return 1 + max;
    }
}

