/*
 * Decompiled with CFR 0.152.
 */
package struct;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import struct.StructData;
import struct.StructException;
import struct.StructFieldData;
import struct.StructUtils;

public abstract class StructOutput
extends OutputStream {
    @Override
    public void write(int arg0) throws IOException {
    }

    public void writeObject(Object obj) throws StructException {
        if (obj == null) {
            throw new StructException("Struct classes cant be null. ");
        }
        StructData info = StructUtils.getStructInfo(obj);
        for (Field currentField : info.getFields()) {
            StructFieldData fieldData = info.getFieldData(currentField.getName());
            if (fieldData == null) {
                throw new StructException("Field Data not found for field: " + currentField.getName());
            }
            boolean lengthArray = false;
            int arrayLength = -1;
            try {
                if (fieldData.isArrayLengthMarker()) {
                    arrayLength = fieldData.requiresGetterSetter() ? ((Number)fieldData.getGetter().invoke(obj, (Object[])null)).intValue() : ((Number)fieldData.getField().get(obj)).intValue();
                    lengthArray = true;
                }
                if (fieldData.requiresGetterSetter()) {
                    if (lengthArray && arrayLength >= 0) {
                        this.writeField(fieldData, fieldData.getGetter(), obj, arrayLength);
                        continue;
                    }
                    this.writeField(fieldData, fieldData.getGetter(), obj, -1);
                    continue;
                }
                if (lengthArray && arrayLength >= 0) {
                    this.writeField(fieldData, null, obj, arrayLength);
                    continue;
                }
                this.writeField(fieldData, null, obj, -1);
            }
            catch (Exception e) {
                throw new StructException(e);
            }
        }
    }

    public void writeField(StructFieldData fieldData, Method getter, Object obj, int len) throws IllegalAccessException, IOException, InvocationTargetException, StructException {
        Field field = fieldData.getField();
        if (!field.getType().isArray()) {
            switch (fieldData.getType()) {
                case BOOLEAN: {
                    if (getter != null) {
                        this.writeBoolean((Boolean)getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.writeBoolean(field.getBoolean(obj));
                    break;
                }
                case BYTE: {
                    if (getter != null) {
                        this.writeByte((Byte)getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.writeByte(field.getByte(obj));
                    break;
                }
                case SHORT: {
                    if (getter != null) {
                        this.writeShort((Short)getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.writeShort(field.getShort(obj));
                    break;
                }
                case INT: {
                    if (getter != null) {
                        this.writeInt((Integer)getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.writeInt(field.getInt(obj));
                    break;
                }
                case LONG: {
                    long longValue = getter != null ? ((Long)getter.invoke(obj, (Object[])null)).longValue() : field.getLong(obj);
                    this.writeLong(longValue);
                    break;
                }
                case CHAR: {
                    if (getter != null) {
                        this.writeChar(((Character)getter.invoke(obj, (Object[])null)).charValue());
                        break;
                    }
                    this.writeChar(field.getChar(obj));
                    break;
                }
                case FLOAT: {
                    if (getter != null) {
                        this.writeFloat(((Float)getter.invoke(obj, (Object[])null)).floatValue());
                        break;
                    }
                    this.writeFloat(field.getFloat(obj));
                    break;
                }
                case DOUBLE: {
                    if (getter != null) {
                        this.writeDouble((Double)getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.writeDouble(field.getDouble(obj));
                    break;
                }
                default: {
                    if (getter != null) {
                        this.handleObject(field, getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.handleObject(field, obj);
                    break;
                }
            }
        } else {
            switch (fieldData.getType()) {
                case BOOLEAN: {
                    if (getter != null) {
                        this.writeBooleanArray((boolean[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeBooleanArray((boolean[])field.get(obj), len);
                    break;
                }
                case BYTE: {
                    if (getter != null) {
                        this.writeByteArray((byte[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeByteArray((byte[])field.get(obj), len);
                    break;
                }
                case SHORT: {
                    if (getter != null) {
                        this.writeShortArray((short[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeShortArray((short[])field.get(obj), len);
                    break;
                }
                case INT: {
                    if (getter != null) {
                        this.writeIntArray((int[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeIntArray((int[])field.get(obj), len);
                    break;
                }
                case LONG: {
                    if (getter != null) {
                        this.writeLongArray((long[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeLongArray((long[])field.get(obj), len);
                    break;
                }
                case CHAR: {
                    if (getter != null) {
                        this.writeCharArray((char[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeCharArray((char[])field.get(obj), len);
                    break;
                }
                case FLOAT: {
                    if (getter != null) {
                        this.writeFloatArray((float[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeFloatArray((float[])field.get(obj), len);
                    break;
                }
                case DOUBLE: {
                    if (getter != null) {
                        this.writeDoubleArray((double[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeDoubleArray((double[])field.get(obj), len);
                    break;
                }
                default: {
                    if (getter != null) {
                        this.writeObjectArray((Object[])getter.invoke(obj, (Object[])null), len);
                        break;
                    }
                    this.writeObjectArray((Object[])field.get(obj), len);
                }
            }
        }
    }

    public void handleObject(Field field, Object obj) throws IllegalArgumentException, StructException, IllegalAccessException {
        this.writeObject(field.get(obj));
    }

    public abstract void writeBoolean(boolean var1) throws IOException;

    public abstract void writeByte(byte var1) throws IOException;

    public abstract void writeShort(short var1) throws IOException;

    public abstract void writeInt(int var1) throws IOException;

    public abstract void writeLong(long var1) throws IOException;

    public abstract void writeChar(char var1) throws IOException;

    public abstract void writeFloat(float var1) throws IOException;

    public abstract void writeDouble(double var1) throws IOException;

    public abstract void writeBooleanArray(boolean[] var1, int var2) throws IOException;

    public abstract void writeByteArray(byte[] var1, int var2) throws IOException;

    public abstract void writeCharArray(char[] var1, int var2) throws IOException;

    public abstract void writeShortArray(short[] var1, int var2) throws IOException;

    public abstract void writeIntArray(int[] var1, int var2) throws IOException;

    public abstract void writeLongArray(long[] var1, int var2) throws IOException;

    public abstract void writeFloatArray(float[] var1, int var2) throws IOException;

    public abstract void writeDoubleArray(double[] var1, int var2) throws IOException;

    public abstract void writeObjectArray(Object[] var1, int var2) throws IOException, IllegalAccessException, InvocationTargetException, StructException;
}

