/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.elixirapi.requests.player;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Consumer;
import tech.xigam.elixirapi.Bot;
import tech.xigam.elixirapi.ElixirAPI;
import tech.xigam.elixirapi.Request;
import tech.xigam.elixirapi.exceptions.RequestBuildException;
import tech.xigam.elixirapi.interfaces.PlayerResponse;
import tech.xigam.elixirapi.objects.TrackObject;
import tech.xigam.elixirapi.requests.player.PlayerRequest;
import tech.xigam.elixirapi.responses.GenericPlayerResponse;
import tech.xigam.elixirapi.responses.TrackResponse;

public final class PlayRequest
extends PlayerRequest {
    private final String guild;
    private final String query;

    public PlayRequest(ElixirAPI api, Bot bot, String guild, String query) {
        super(api, bot);
        this.guild = guild;
        this.query = query;
    }

    @Override
    public void execute(Consumer<PlayerResponse> response) {
        Request request = new Request.Builder(this.api).method(Request.Method.POST).endpoint("play").argument("bot", this.bot.getBotId()).argument("guild", this.guild).argument("query", this.query).build();
        request.execute((tech.xigam.elixirapi.Response res) -> new GenericPlayerResponse(res.getResponse(), res.getResponseCode()));
    }

    public static class Response
    extends TrackResponse {
        public Response(String response, int responseCode) {
            super(response, responseCode);
        }

        @Override
        public TrackObject getAsTrack() {
            JsonObject jsonObject = JsonParser.parseString((String)this.getResponse()).getAsJsonObject();
            return (TrackObject)new Gson().fromJson(jsonObject.get("data"), TrackObject.class);
        }
    }

    public static class Builder
    extends PlayerRequest.Builder {
        public Builder(ElixirAPI api) {
            super(api);
        }

        public Builder track(String query) {
            this.query = this.api.shouldUseBase64() ? Base64.getUrlEncoder().encodeToString(query.getBytes()) : URLEncoder.encode(query, StandardCharsets.UTF_8);
            return this;
        }

        @Override
        public PlayerRequest build() throws RequestBuildException {
            if (this.bot == null) {
                this.bot = this.api.preferredBot();
            }
            return new PlayRequest(this.api, this.bot, this.guild, this.query);
        }
    }
}

