/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.codecs.OptionalCodec;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ESExprCodec<T> {
    @NotNull
    public abstract @NotNull Set<@NotNull ESExprTag> tags();

    @NotNull
    public abstract ESExpr encode(@NotNull T var1);

    @NotNull
    public final T decode(@NotNull ESExpr expr) throws DecodeException {
        return this.decode(expr, new FailurePath.Current());
    }

    @NotNull
    public abstract T decode(@NotNull ESExpr var1, @NotNull FailurePath var2) throws DecodeException;

    public static <T> ESExprCodec<Optional<T>> optionalCodec(ESExprCodec<T> itemCodec) {
        return new OptionalCodec<T>(itemCodec);
    }

    public static sealed interface FailurePath {
        public FailurePath append(String var1, int var2);

        public FailurePath append(String var1, String var2);

        public FailurePath withConstructor(String var1);

        public record Keyword(String constructor, String keyword, FailurePath next) implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Keyword(this.constructor, this.keyword, this.next.append(constructor, index));
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Keyword(this.constructor, keyword, this.next.append(constructor, keyword));
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Keyword(this.constructor, this.keyword, this.next.withConstructor(constructor));
            }
        }

        public record Positional(String constructor, int index, FailurePath next) implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Positional(this.constructor, this.index, this.next.append(constructor, index));
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Positional(this.constructor, this.index, this.next.append(constructor, keyword));
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Positional(this.constructor, this.index, this.next.withConstructor(constructor));
            }
        }

        public record Constructor(String name) implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Positional(constructor, index, new Current());
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Keyword(constructor, keyword, new Current());
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Constructor(constructor);
            }
        }

        public record Current() implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Positional(constructor, index, this);
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Keyword(constructor, keyword, this);
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Constructor(constructor);
            }
        }
    }
}

