/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.OptionalValueCodec;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@ESExprOverrideCodec(value=Optional.class, codecType=ESExprOverrideCodec.CodecType.OPTIONAL_VALUE)
public class OptionalOptionalValueCodec<T>
implements OptionalValueCodec<Optional<T>> {
    private final ESExprCodec<T> elementCodec;

    public OptionalOptionalValueCodec(ESExprCodec<T> elementCodec) {
        this.elementCodec = elementCodec;
    }

    @Override
    public Optional<ESExpr> encodeOptional(Optional<T> value) {
        return value.map(this.elementCodec::encode);
    }

    @Override
    public Optional<T> decodeOptional(Optional<ESExpr> expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        ESExpr expr2 = expr.orElse(null);
        if (expr2 == null) {
            return Optional.empty();
        }
        T value = this.elementCodec.decode(expr2, path);
        return Optional.of(value);
    }
}

