/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.OptionalValueCodec;
import java.util.Optional;

@ESExprOverrideCodec(value=Optional.class, codecType=ESExprOverrideCodec.CodecType.OPTIONAL_VALUE)
public class OptionalOptionalValueCodec<T>
implements OptionalValueCodec<Optional<T>, T> {
    private final ESExprCodec<T> elementCodec;

    public OptionalOptionalValueCodec(ESExprCodec<T> elementCodec) {
        this.elementCodec = elementCodec;
    }

    @Override
    public boolean isEncodedEqual(Optional<T> x, Optional<T> y) {
        if (x.isEmpty()) {
            return y.isEmpty();
        }
        if (y.isEmpty()) {
            return false;
        }
        return this.elementCodec.isEncodedEqual(x.get(), y.get());
    }

    @Override
    public Optional<ESExpr> encodeOptional(Optional<T> value) {
        return value.map(this.elementCodec::encode);
    }

    @Override
    public Optional<T> decodeOptional(Optional<ESExpr> expr, ESExprCodec.FailurePath path) throws DecodeException {
        ESExpr expr2 = expr.orElse(null);
        if (expr2 == null) {
            return Optional.empty();
        }
        T value = this.elementCodec.decode(expr2, path);
        return Optional.of(value);
    }
}

