/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import com.google.android.gms.auth.api.signin.zaa;
import com.google.android.gms.auth.api.signin.zab;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInAccountCreator")
public class GoogleSignInAccount
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR;
    @VisibleForTesting
    @NonNull
    public static Clock zaa;
    @SafeParcelable.VersionField(id=1)
    final int zab;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getId")
    private String zad;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getIdToken")
    private String zae;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getEmail")
    private String zaf;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getDisplayName")
    private String zag;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getPhotoUrl")
    private Uri zah;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getServerAuthCode")
    private String zai;
    @SafeParcelable.Field(id=8, getter="getExpirationTimeSecs")
    private long zaj;
    @SafeParcelable.Field(id=9, getter="getObfuscatedIdentifier")
    private String zak;
    @SafeParcelable.Field(id=10)
    List<Scope> zac;
    @Nullable
    @SafeParcelable.Field(id=11, getter="getGivenName")
    private String zal;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getFamilyName")
    private String zam;
    private Set<Scope> zan;

    public int hashCode() {
        return (this.zak.hashCode() + 527) * 31 + this.getRequestedScopes().hashCode();
    }

    @Nullable
    public Account getAccount() {
        String this_ = ((GoogleSignInAccount)((Object)this_)).zaf;
        if (this_ == null) {
            return null;
        }
        Account account = new Account(this_, "com.google");
        return account;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zah;
    }

    @KeepForSdk
    @NonNull
    public static GoogleSignInAccount createDefault() {
        Account account = new Account("<<default account>>", "com.google");
        HashSet<Scope> hashSet = new HashSet<Scope>();
        return GoogleSignInAccount.zae(account, hashSet);
    }

    @KeepForSdk
    @NonNull
    public static GoogleSignInAccount fromAccount(@NonNull Account account) {
        Account account2;
        ArraySet arraySet = new ArraySet();
        return GoogleSignInAccount.zae(account2, (Set<Scope>)arraySet);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public GoogleSignInAccount requestExtraScopes(Scope ... scopes) {
        if (scopes != null) {
            void var1_1;
            Collections.addAll(this.zan, var1_1);
        }
        return this;
    }

    @Nullable
    public String getDisplayName() {
        return this.zag;
    }

    @Nullable
    public String getEmail() {
        return this.zaf;
    }

    @Nullable
    public String getFamilyName() {
        return this.zam;
    }

    @Nullable
    public String getGivenName() {
        return this.zal;
    }

    @Nullable
    public String getId() {
        return this.zad;
    }

    @Nullable
    public String getIdToken() {
        return this.zae;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zai;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zac);
        return hashSet;
    }

    @NonNull
    @KeepForSdk
    public Set<Scope> getRequestedScopes() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zac);
        hashSet.addAll(this.zan);
        return hashSet;
    }

    static {
        zab zab2;
        CREATOR = zab2 = new zab();
        zaa = DefaultClock.getInstance();
    }

    @SafeParcelable.Constructor
    GoogleSignInAccount(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=5) @Nullable String string5, @SafeParcelable.Param(id=6) @Nullable Uri uri, @SafeParcelable.Param(id=7) @Nullable String string6, @SafeParcelable.Param(id=8) long l, @SafeParcelable.Param(id=9) String string7, @SafeParcelable.Param(id=10) List<Scope> list, @SafeParcelable.Param(id=11) @Nullable String string8, @SafeParcelable.Param(id=12) @Nullable String string9) {
        HashSet<Scope> hashSet = new HashSet<Scope>();
        this.zan = hashSet;
        this.zab = n;
        this.zad = string2;
        this.zae = string3;
        this.zaf = string4;
        this.zag = string5;
        this.zah = uri;
        this.zai = string6;
        this.zaj = l;
        this.zak = string7;
        this.zac = list;
        this.zal = string8;
        this.zam = string9;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader(out);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1, this.zab);
        SafeParcelWriter.writeString((Parcel)var1_1, 2, this.getId(), false);
        SafeParcelWriter.writeString((Parcel)var1_1, 3, this.getIdToken(), false);
        SafeParcelWriter.writeString((Parcel)var1_1, 4, this.getEmail(), false);
        SafeParcelWriter.writeString((Parcel)var1_1, 5, this.getDisplayName(), false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 6, (Parcelable)((Object)this.getPhotoUrl()), (int)var2_2, false);
        SafeParcelWriter.writeString((Parcel)var1_1, 7, this.getServerAuthCode(), false);
        SafeParcelWriter.writeLong((Parcel)var1_1, 8, this.zaj);
        SafeParcelWriter.writeString((Parcel)var1_1, 9, this.zak, false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, 10, this.zac, false);
        SafeParcelWriter.writeString((Parcel)var1_1, 11, this.getGivenName(), false);
        SafeParcelWriter.writeString((Parcel)var1_1, 12, this.getFamilyName(), false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, n);
    }

    public boolean equals(@Nullable Object obj) {
        GoogleSignInAccount googleSignInAccount;
        if (obj == null) {
            return false;
        }
        if (googleSignInAccount == this) {
            return true;
        }
        if (!(googleSignInAccount instanceof GoogleSignInAccount)) {
            return false;
        }
        googleSignInAccount = googleSignInAccount;
        return googleSignInAccount.zak.equals(this.zak) && googleSignInAccount.getRequestedScopes().equals(this.getRequestedScopes());
    }

    @KeepForSdk
    public boolean isExpired() {
        return zaa.currentTimeMillis() / 1000L >= this.zaj + -300L;
    }

    @NonNull
    public static GoogleSignInAccount zaa(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Uri uri, @Nullable Long object, @NonNull String arrayList, @NonNull Set<Scope> set) {
        long l = (Long)object;
        object = Preconditions.checkNotEmpty((String)((Object)arrayList));
        arrayList = new ArrayList<Scope>((Collection)Preconditions.checkNotNull(set));
        GoogleSignInAccount googleSignInAccount = new GoogleSignInAccount(3, string2, string3, string4, string5, uri, null, l, (String)object, arrayList, string6, string7);
        return googleSignInAccount;
    }

    private static GoogleSignInAccount zae(Account account, Set<Scope> set) {
        return GoogleSignInAccount.zaa(null, null, account.name, null, null, null, null, 0L, account.name, set);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static GoogleSignInAccount zab(@Nullable String object) throws JSONException {
        Object object2;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject((String)object);
        object = !TextUtils.isEmpty((CharSequence)(object = jSONObject.optString("photoUrl"))) ? Uri.parse((String)object) : null;
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        Object object3 = jSONObject.getJSONArray("grantedScopes");
        int n = ((JSONArray)object3).length();
        for (int i = 0; i < n; ++i) {
            object2 = new Scope(((JSONArray)object3).getString(i));
            hashSet.add((Scope)object2);
        }
        String string2 = jSONObject.optString("id");
        Object object4 = jSONObject.has("tokenId") ? jSONObject.optString("tokenId") : null;
        object3 = jSONObject.has("email") ? jSONObject.optString("email") : null;
        String string3 = jSONObject.has("displayName") ? jSONObject.optString("displayName") : null;
        object2 = jSONObject.has("givenName") ? jSONObject.optString("givenName") : null;
        String string4 = jSONObject.has("familyName") ? jSONObject.optString("familyName") : null;
        object4 = GoogleSignInAccount.zaa(string2, (String)object4, (String)object3, string3, (String)object2, string4, (Uri)object, l, jSONObject.getString("obfuscatedIdentifier"), hashSet);
        object = jSONObject.has("serverAuthCode") ? jSONObject.optString("serverAuthCode") : null;
        ((GoogleSignInAccount)object4).zai = object;
        return object4;
    }

    @NonNull
    public final String zac() {
        return this.zak;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final String zad() {
        Object object;
        Object object2 = new JSONObject();
        try {
            object = ((GoogleSignInAccount)((Object)list)).getId();
            if (object != null) {
                ((JSONObject)object2).put("id", ((GoogleSignInAccount)((Object)list)).getId());
            }
            if ((object = ((GoogleSignInAccount)((Object)list)).getIdToken()) != null) {
                ((JSONObject)object2).put("tokenId", ((GoogleSignInAccount)((Object)list)).getIdToken());
            }
            if ((object = ((GoogleSignInAccount)((Object)list)).getEmail()) != null) {
                ((JSONObject)object2).put("email", ((GoogleSignInAccount)((Object)list)).getEmail());
            }
            if ((object = ((GoogleSignInAccount)((Object)list)).getDisplayName()) != null) {
                ((JSONObject)object2).put("displayName", ((GoogleSignInAccount)((Object)list)).getDisplayName());
            }
            if ((object = ((GoogleSignInAccount)((Object)list)).getGivenName()) != null) {
                ((JSONObject)object2).put("givenName", ((GoogleSignInAccount)((Object)list)).getGivenName());
            }
            if ((object = ((GoogleSignInAccount)((Object)list)).getFamilyName()) != null) {
                ((JSONObject)object2).put("familyName", ((GoogleSignInAccount)((Object)list)).getFamilyName());
            }
            if ((object = ((GoogleSignInAccount)((Object)list)).getPhotoUrl()) != null) {
                ((JSONObject)object2).put("photoUrl", object.toString());
            }
            if ((object = ((GoogleSignInAccount)((Object)list)).getServerAuthCode()) != null) {
                ((JSONObject)object2).put("serverAuthCode", ((GoogleSignInAccount)((Object)list)).getServerAuthCode());
            }
            ((JSONObject)object2).put("expirationTime", ((GoogleSignInAccount)((Object)list)).zaj);
            object = "obfuscatedIdentifier";
            Scope[] scopeArray = ((GoogleSignInAccount)((Object)list)).zak;
            ((JSONObject)object2).put((String)object, scopeArray);
            object = new JSONArray();
            List<Scope> list = ((GoogleSignInAccount)((Object)list)).zac;
            scopeArray = list.toArray(new Scope[list.size()]);
            Arrays.sort(scopeArray, com.google.android.gms.auth.api.signin.zaa.zaa);
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                ((JSONArray)object).put(scopeArray[i].getScopeUri());
            }
        }
        catch (JSONException jSONException) {
            object2 = new RuntimeException(jSONException);
            throw object2;
        }
        {
            ((JSONObject)object2).put("grantedScopes", object);
        }
        ((JSONObject)object2).remove("serverAuthCode");
        return ((JSONObject)object2).toString();
    }
}

