/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.wrappers.Wrappers;

@KeepForSdk
public class ClientLibraryUtils {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static int getClientVersion(@NonNull Context context, @NonNull String packageName) {
        void var1_1;
        Object object = ClientLibraryUtils.getPackageInfo(context, (String)var1_1);
        if (object == null || ((PackageInfo)object).applicationInfo == null || (object = ((PackageInfo)object).applicationInfo.metaData) == null) {
            return -1;
        }
        return object.getInt("com.google.android.gms.version", -1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public static PackageInfo getPackageInfo(@NonNull Context context, @NonNull String packageName) {
        try {
            void var1_1;
            PackageInfo packageInfo = Wrappers.packageManager(context).getPackageInfo((String)var1_1, 128);
            return packageInfo;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private ClientLibraryUtils() {
    }

    @KeepForSdk
    public static boolean isPackageSide() {
        return false;
    }
}

