/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatablePreserveAspectRatioValue
extends AnimatableValue {
    protected static final String[] ALIGN_VALUES = new String[]{null, "none", "xMinYMin", "xMidYMin", "xMaxYMin", "xMinYMid", "xMidYMid", "xMaxYMid", "xMinYMax", "xMidYMax", "xMaxYMax"};
    protected static final String[] MEET_OR_SLICE_VALUES = new String[]{null, "meet", "slice"};
    protected short align;
    protected short meetOrSlice;

    protected AnimatablePreserveAspectRatioValue(AnimationTarget target) {
        super(target);
    }

    public AnimatablePreserveAspectRatioValue(AnimationTarget target, short align, short meetOrSlice) {
        super(target);
        this.align = align;
        this.meetOrSlice = meetOrSlice;
    }

    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to2, float interpolation, AnimatableValue accumulation, int multiplier) {
        short newMeetOrSlice;
        short newAlign;
        AnimatablePreserveAspectRatioValue res = result2 == null ? new AnimatablePreserveAspectRatioValue(this.target) : (AnimatablePreserveAspectRatioValue)result2;
        if (to2 != null && (double)interpolation >= 0.5) {
            AnimatablePreserveAspectRatioValue toValue = (AnimatablePreserveAspectRatioValue)to2;
            newAlign = toValue.align;
            newMeetOrSlice = toValue.meetOrSlice;
        } else {
            newAlign = this.align;
            newMeetOrSlice = this.meetOrSlice;
        }
        if (res.align != newAlign || res.meetOrSlice != newMeetOrSlice) {
            res.align = this.align;
            res.meetOrSlice = this.meetOrSlice;
            res.hasChanged = true;
        }
        return res;
    }

    public short getAlign() {
        return this.align;
    }

    public short getMeetOrSlice() {
        return this.meetOrSlice;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        return new AnimatablePreserveAspectRatioValue(this.target, 1, 1);
    }

    public String toStringRep() {
        if (this.align < 1 || this.align > 10) {
            return null;
        }
        String value2 = ALIGN_VALUES[this.align];
        if (this.align == 1) {
            return value2;
        }
        if (this.meetOrSlice < 1 || this.meetOrSlice > 2) {
            return null;
        }
        return value2 + ' ' + MEET_OR_SLICE_VALUES[this.meetOrSlice];
    }
}

