/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg12;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.LengthManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg12.LineHeightValue;
import org.apache.batik.css.engine.value.svg12.SVG12ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends LengthManager {
    public boolean isInheritedProperty() {
        return true;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public int getPropertyType() {
        return 43;
    }

    public String getPropertyName() {
        return "line-height";
    }

    public Value getDefaultValue() {
        return SVG12ValueConstants.NORMAL_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String s2 = lu.getStringValue().toLowerCase();
                if ("normal".equals(s2)) {
                    return SVG12ValueConstants.NORMAL_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lu.getStringValue());
            }
        }
        return super.createValue(lu, engine);
    }

    protected int getOrientation() {
        return 1;
    }

    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value2) {
        if (value2.getCssValueType() != 1) {
            return value2;
        }
        switch (value2.getPrimitiveType()) {
            case 1: {
                return new LineHeightValue(1, value2.getFloatValue(), true);
            }
            case 2: {
                float v = value2.getFloatValue();
                int fsidx = engine.getFontSizeIndex();
                float fs = engine.getComputedStyle(elt, pseudo, fsidx).getFloatValue();
                return new FloatValue(1, v * fs * 0.01f);
            }
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value2);
    }
}

