/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.AbstractSVGNumber;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.parser.NumberListHandler;
import org.apache.batik.parser.NumberListParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public abstract class AbstractSVGNumberList
extends AbstractSVGList
implements SVGNumberList {
    public static final String SVG_NUMBER_LIST_SEPARATOR = " ";

    protected String getItemSeparator() {
        return SVG_NUMBER_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGNumberList() {
    }

    public SVGNumber initialize(SVGNumber newItem) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.initializeImpl(newItem));
    }

    public SVGNumber getItem(int index2) throws DOMException {
        return (SVGNumber)((Object)this.getItemImpl(index2));
    }

    public SVGNumber insertItemBefore(SVGNumber newItem, int index2) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.insertItemBeforeImpl(newItem, index2));
    }

    public SVGNumber replaceItem(SVGNumber newItem, int index2) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.replaceItemImpl(newItem, index2));
    }

    public SVGNumber removeItem(int index2) throws DOMException {
        return (SVGNumber)((Object)this.removeItemImpl(index2));
    }

    public SVGNumber appendItem(SVGNumber newItem) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.appendItemImpl(newItem));
    }

    protected SVGItem createSVGItem(Object newItem) {
        SVGNumber l = (SVGNumber)newItem;
        return new SVGNumberItem(l.getValue());
    }

    protected void doParse(String value2, ListHandler handler) throws ParseException {
        NumberListParser NumberListParser2 = new NumberListParser();
        NumberListBuilder builder = new NumberListBuilder(handler);
        NumberListParser2.setNumberListHandler(builder);
        NumberListParser2.parse(value2);
    }

    protected void checkItemType(Object newItem) throws SVGException {
        if (!(newItem instanceof SVGNumber)) {
            this.createSVGException((short)0, "expected SVGNumber", null);
        }
    }

    protected class NumberListBuilder
    implements NumberListHandler {
        protected ListHandler listHandler;
        protected float currentValue;

        public NumberListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startNumberList() throws ParseException {
            this.listHandler.startList();
        }

        public void startNumber() throws ParseException {
            this.currentValue = 0.0f;
        }

        public void numberValue(float v) throws ParseException {
            this.currentValue = v;
        }

        public void endNumber() throws ParseException {
            this.listHandler.item(new SVGNumberItem(this.currentValue));
        }

        public void endNumberList() throws ParseException {
            this.listHandler.endList();
        }
    }

    protected class SVGNumberItem
    extends AbstractSVGNumber
    implements SVGItem {
        protected AbstractSVGList parentList;

        public SVGNumberItem(float value2) {
            this.value = value2;
        }

        public String getValueAsString() {
            return Float.toString(this.value);
        }

        public void setParent(AbstractSVGList list2) {
            this.parentList = list2;
        }

        public AbstractSVGList getParent() {
            return this.parentList;
        }

        protected void reset() {
            if (this.parentList != null) {
                this.parentList.itemChanged();
            }
        }
    }
}

