/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SizeFileFilter
extends AbstractFileFilter {
    private long size;
    private boolean acceptLarger;

    public SizeFileFilter(long size2) {
        this(size2, true);
    }

    public SizeFileFilter(long size2, boolean acceptLarger) {
        if (size2 < 0L) {
            throw new IllegalArgumentException("The size must be non-negative");
        }
        this.size = size2;
        this.acceptLarger = acceptLarger;
    }

    public boolean accept(File file) {
        boolean smaller;
        boolean bl = smaller = file.length() < this.size;
        return this.acceptLarger ? !smaller : smaller;
    }
}

