/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public final class ColorProperty
extends Property {
    private static final PropertyCache<ColorProperty> CACHE = new PropertyCache();
    protected final Color color;

    public static ColorProperty getInstance(FOUserAgent foUserAgent, String value2) throws PropertyException {
        ColorProperty instance = new ColorProperty(org.apache.fop.util.ColorUtil.parseColorString(foUserAgent, value2));
        return CACHE.fetch(instance);
    }

    private ColorProperty(Color value2) {
        this.color = value2;
    }

    public Color getColor(FOUserAgent foUserAgent) {
        return this.color;
    }

    public String toString() {
        return org.apache.fop.util.ColorUtil.colorToString(this.color);
    }

    public ColorProperty getColorProperty() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ColorProperty) {
            return ColorUtil.isSameColor(((ColorProperty)o).color, this.color);
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof ColorProperty) {
                return p;
            }
            FObj fobj = fo == null ? propertyList.getFObj() : fo;
            FOUserAgent ua = fobj == null ? null : fobj.getUserAgent();
            Color val = p.getColor(ua);
            if (val != null) {
                return new ColorProperty(val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

