/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;

public final class StringProperty
extends Property {
    private static final PropertyCache<StringProperty> CACHE = new PropertyCache();
    public static final StringProperty EMPTY_STRING_PROPERTY = new StringProperty("");
    private final String str;

    private StringProperty(String str) {
        this.str = str;
    }

    public static StringProperty getInstance(String str) {
        if ("".equals(str) || str == null) {
            return EMPTY_STRING_PROPERTY;
        }
        return CACHE.fetch(new StringProperty(str));
    }

    public Object getObject() {
        return this.str;
    }

    public String getString() {
        return this.str;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringProperty) {
            StringProperty sp2 = (StringProperty)obj;
            return sp2.str == this.str || sp2.str.equals(this.str);
        }
        return false;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property make(PropertyList propertyList, String value2, FObj fo) {
            int vlen = value2.length() - 1;
            if (vlen > 0) {
                String str;
                char q1 = value2.charAt(0);
                if (q1 == '\"' || q1 == '\'') {
                    if (value2.charAt(vlen) == q1) {
                        return new StringProperty(value2.substring(1, vlen));
                    }
                    Property.log.warn("String-valued property starts with quote but doesn't end with quote: " + value2);
                }
                if ((str = this.checkValueKeywords(value2)) != null) {
                    value2 = str;
                }
            }
            return StringProperty.getInstance(value2);
        }
    }
}

